{ open Parser }

rule token = parse
  [' ' '\t' '\r' '\n'] { token lexbuf }
| "/*" { comment lexbuf }
| '"' { strlit (Buffer.create 16) lexbuf }
| '+' { PLUS }
| '-' { MINUS }
| '*' { TIMES }
| '/' { DIVIDE }
| "==" { EQ }
| "!=" { NEQ }
| '<' { LT }
| "<=" { LEQ }
| '>' { GT }
| ">=" { GEQ }
| '=' { ASSIGN }
| ',' { COMMA }
| '.' { DOT }
| '!' { NOT }
| '(' { LPAREN }
| ')' { RPAREN }
| '{' { LBRACE }
| '}' { RBRACE }
| '[' { LBRACK }
| ']' { RBRACK }
| ';' { SEMI }
| ':' { COLON }
| "->" { RARROW }
| "where" { WHERE }
| "and" { AND }
| "or" { OR }
| "if" { IF }
| "else" { ELSE }
| "for" { FOR }
| "in" { IN }
| "while" { WHILE }
| "func" { FUNC }
| "return" { RETURN }
| "bool" { BOOL }
| "int" { INT }
| "string" { STRING }
| "list" { LIST }
| "edge" { EDGE }
| "node" { NODE }
| "graph" { GRAPH }
| "del" { DEL }
| "true" { TRUE }
| "false" { FALSE }
| "NIL" { NIL }
| "INF" { INF }
| "node:" (['a'-'z' 'A'-'Z']['a'-'z' 'A'-'Z' '0'-'9' '_']* as lxm) { TNNODE(lxm) }
| ['a'-'z' 'A'-'Z']['a'-'z' 'A'-'Z' '0'-'9' '_']* as lxm { ID(lxm) }
| ['0'-'9']+ as lit { INTLIT(int_of_string lit) }
| eof { EOF }
| _ as char { raise (Failure("Illegal character "^ Char.escaped char)) }

and strlit buf = parse
  | '"' { STRLIT(Buffer.contents buf) }
  | '\\' '\\' { Buffer.add_char buf '\\'; strlit buf lexbuf }
  | '\\' 'b' { Buffer.add_char buf '\b'; strlit buf lexbuf }
  | '\\' 'f' { Buffer.add_char buf '\012'; strlit buf lexbuf }
  | '\\' 'n' { Buffer.add_char buf '\n'; strlit buf lexbuf }
  | '\\' 'r' { Buffer.add_char buf '\r'; strlit buf lexbuf }
  | '\\' 't' { Buffer.add_char buf '\t'; strlit buf lexbuf }
  | '\\' '"' { Buffer.add_char buf '\"'; strlit buf lexbuf }
  | [^ '"' '\\']+
    { Buffer.add_string buf (Lexing.lexeme lexbuf);
      strlit buf lexbuf
    }
  | _ { raise (Failure("Illegal string character: "^ Lexing.lexeme lexbuf)) }
  | eof { raise (Failure("String is not terminated")) }

and comment = parse
  "*/" { token lexbuf }
| _    { comment lexbuf }
