type unop = Neg | Not

type biop = Add | Sub | Mul | Div | Eq | Neq | Lt | Leq | Gt | Geq | And | Or

type typ =
  TEdge
| TNode
| TNNode of string
| TGraph
| TInt
| TBool
| TStr
| TList of typ
| TVoid

type typdname = typ * string

type graph_elem =
  NodeId of string
| EdgeId of string * string * string

type expr =
  IntLit of int
| BoolLit of bool
| StrLit of string
| Lst of typ * expr list
| Id of string
| Unop of unop * expr
| Biop of expr * biop * expr
| Call of string * expr list
| GraphAccess of string * graph_elem * string list
| Property of expr * string
| Nil of typ
| Inf

type patt = {
  pids : string list;
  preds : (string * int) list;
}

type graph_stmt =
  GraphSet of graph_elem list * (string * int) list
| GraphDel of graph_elem list

type stmt =
  Assign of expr * expr
| Block of typdname list * stmt list
| Expr of expr
| Return of expr
| If of expr * stmt * stmt
| For of typ * string * patt * expr * bool * stmt * string list
| While of expr * stmt
| GraphDef of string * graph_stmt list * string list

type node_decl = {
  nname : string;
  nidpatt : string;
  npatt : patt;
}

type graph_decl = {
  gname : string;
  gbody : graph_stmt list;
}

type func_decl = {
  fname : string;
  freturns : typ;
  formals : typdname list;
  flocals : typdname list;
  fbody : stmt list;
}

type program = node_decl list * graph_decl list * func_decl list

let string_of_biop = function
  Add -> "+"
| Sub -> "-"
| Mul -> "*"
| Div -> "//"
| Eq -> "=="
| Neq -> "!="
| Lt -> "<"
| Leq -> "<="
| Gt -> ">"
| Geq -> ">="
| And -> "and"
| Or -> "or"
