type action = Ast | Interpret | Bytecode | Compile

let _ =
  let action = if Array.length Sys.argv > 1
    then List.assoc Sys.argv.(1) [ ("-a", Ast);
			      ("-c", Compile) ]
    else Compile
  in

  let lexbuf = Lexing.from_channel stdin in
  let program = (try Parser.program Scanner.token lexbuf
                 with Parsing.Parse_error -> raise (Failure ("Program did not parse successfully.")))
  in

  let sprogram = Semana.translate program in

  match action with
    Ast -> let listing = Ast.string_of_program program
           in print_string listing
  | Compile -> print_string (Compile.translate sprogram)
  | _ -> print_string "INVALID OPTION\n"
