%{
open Ast;;
let get1 (x,_,_) = x;;
let get2 (_,x,_) = x;;
let get3 (_,_,x) = x;;
 %}

%token EOF PLUS MINUS TIMES DIVIDE EQ NEQ LT LEQ GT GEQ COLON
%token ASSIGN COMMA DOT NOT LPAREN RPAREN LBRACE RBRACE LBRACK RBRACK
%token SEMI RARROW AND OR IF ELSE FOR IN WHILE WHERE FUNC RETURN
%token BOOL INT STRING LIST EDGE NODE GRAPH DEL TRUE FALSE NIL INF
%token <int> INTLIT
%token <string> STRLIT ID TNNODE

%nonassoc NOELSE
%nonassoc ELSE
%right ASSIGN
%left OR
%left AND
%left EQ NEQ
%left LT LEQ GT GEQ
%left PLUS MINUS
%left TIMES DIVIDE
%nonassoc LBRACK RBRACK
%left NEG NOT
%left DOT

%start program
%type <Ast.program> program

%%

program:
  decs EOF { $1 }

decs:
  { [], [], [] }
| decs named_node_def { ($2 :: get1 $1), get2 $1, get3 $1 }
| decs graph_dec { get1 $1, ($2 :: get2 $1), get3 $1 }
| decs func_dec { get1 $1, get2 $1, ($2 :: get3 $1) }

named_node_def:
  NODE ID ASSIGN ID IN pattern SEMI { { nname = $2; nidpatt = $4; npatt = $6 } }

graph_dec:
  GRAPH ID LBRACE gelem_def_list RBRACE { { gname = $2; gbody = List.rev $4 } }

func_dec:
  FUNC ID LPAREN formals_opt RPAREN RETURN typ LBRACE vdecls_opt stmt_list RBRACE
    { { fname = $2; freturns = $7; formals = $4; flocals = List.rev $9; fbody = List.rev $10 } }
| FUNC ID LPAREN formals_opt RPAREN LBRACE vdecls_opt stmt_list RBRACE
    { { fname = $2; freturns = TVoid; formals = $4; flocals = List.rev $7; fbody = List.rev $8 } }

pattern:
  nen_patt                   { { pids = $1; preds = [] } }
| nen_patt WHERE gprop_list  { { pids = $1; preds = List.rev $3 } }

nen_patt:
  ID                     { [$1] }
| nen_patt ID RARROW ID  { $4::($2::$1) }

graph_def:
  ID LBRACE gelem_def_list RBRACE { GraphDef($1, List.rev $3) }

gelem_def_list:
  { [] }
| gelem_def_list gelem_def { $2 :: $1 }

gelem_def:
  gedge_def gelem_props SEMI { GraphSet([$1], $2) }
| gnode_def_list gelem_props SEMI { GraphSet(List.rev $1, $2) }
| DEL gedge_def SEMI { GraphDel([$2]) }
| DEL gnode_def_list SEMI { GraphDel(List.rev $2) }

gnode_def_list:
  ID { [NodeId($1)] }
| gnode_def_list COMMA ID { NodeId($3) :: $1 }

gedge_def:
  ID ID RARROW ID { EdgeId($1, $2, $4) }

gelem_props:
  { [] }
| WHERE gprop_list { List.rev $2 }

gprop_list:
  ID ASSIGN INTLIT { [($1, $3)] }
| ID ASSIGN MINUS INTLIT { [($1, -$4)] }
| gprop_list COMMA ID ASSIGN INTLIT { ($3, $5) :: $1 }
| gprop_list COMMA ID ASSIGN MINUS INTLIT { ($3, -$6) :: $1 }

vdecls_opt:
                     { [] }
| vdecls_opt vdecls  { $2 @ $1 }

vdecls:
  typ id_list SEMI   { List.map (fun x -> ($1, x)) $2 }

id_list:
  ID                 { [$1] }
| id_list COMMA ID   { $3 :: $1 }

formals_opt:
  { [] }
| formal_list { List.rev $1 }

formal_list:
  typ ID  { [($1,$2)] }
| formal_list COMMA typ ID { ($3,$4)::$1 }

typ:
  BOOL { TBool }
| INT { TInt }
| STRING { TStr }
| typ LIST { TList($1) }
| EDGE { TEdge }
| NODE { TNode }
| TNNODE { TNNode($1) }
| GRAPH { TGraph }

stmt_list:
  { [] }
| stmt_list stmt { $2::$1 }

stmt:
  expr SEMI      { Expr $1 }
| expr ASSIGN expr SEMI { Assign($1, $3) }
| RETURN expr SEMI { Return $2 }
| IF expr block %prec NOELSE { If($2, $3, Block([], [])) }
| IF expr block ELSE block { If($2, $3, $5) }
| FOR typ ID IN pattern IN expr block { For($2, $3, $5, $7, $8) }
| FOR typ ID IN expr block { For($2, $3, {pids=[];preds=[]}, $5, $6) }
| WHILE expr block { While($2, $3) }
| graph_def        { $1 } 

block:
  LBRACE vdecls_opt stmt_list RBRACE { Block(List.rev $2, List.rev $3) }

exprs_opt:
  { [] }
| expr_list { List.rev $1 }

expr_list:
  expr { [$1] }
| expr_list COMMA expr { $3::$1 }

expr:
  expr PLUS   expr { Biop($1, Add, $3) }
| expr MINUS  expr { Biop($1, Sub, $3) }
| MINUS expr %prec NEG { Unop(Neg, $2) }
| expr TIMES  expr { Biop($1, Mul, $3) }
| expr DIVIDE expr { Biop($1, Div, $3) }
| expr EQ     expr { Biop($1, Eq, $3) }
| expr NEQ    expr { Biop($1, Neq, $3) }
| expr LT     expr { Biop($1, Lt, $3) }
| expr LEQ    expr { Biop($1, Leq, $3) }
| expr GT     expr { Biop($1, Gt, $3) }
| expr GEQ    expr { Biop($1, Geq, $3) }
| expr OR     expr { Biop($1, Or, $3) }
| expr AND    expr { Biop($1, And, $3) }
| expr DOT ID      { Property($1, $3) }
| NOT expr         { Unop(Not, $2) }
| ID COLON LPAREN graph_elem_id RPAREN { GraphAccess($1, $4) }
| ID LPAREN exprs_opt RPAREN { Call($1, $3) }
| LIST typ LBRACK exprs_opt RBRACK { Lst($2, $4) }
| LPAREN expr RPAREN { $2 }
| NIL LPAREN typ RPAREN { Nil($3) }
| INF              { Inf }
| literal          { $1 }
| ID               { Id($1) }

literal:
  TRUE             { BoolLit(true) }
| FALSE            { BoolLit(false) }
| INTLIT           { IntLit($1) }
| STRLIT           { StrLit($1) }

graph_elem_id:
  ID { NodeId($1) }
| ID ID RARROW ID { EdgeId($1, $2, $4) }
