(*tail.ml

to run:
$ ./tail < test > test.ll
$ lli tail.ll

*)

open Ast
open Analyzer
open RobotsInDisguise

type action = Ast | Compile

let _ =

  let action = if Array.length Sys.argv > 1 then
    	List.assoc Sys.argv.(1) [ ("-a", Ast);	(* Print the AST only *)
			  ("-c", Compile) ] (* Generate, check LLVM IR *)
  else Compile in 

(*pipe program file into compiler's lexbuf*)
  let lexbuf = Lexing.from_channel stdin  in 
  let ast = Parser.program Scanner.token lexbuf in
  match action with
	Ast -> print_string (Ast.string_of_program ast)
 	| Compile -> let sast = Analyzer.analyze ast in
  			let envi = RobotsInDisguise.analyze sast in
			let result = Codegen.translate envi
                        in print_string result
			(*in print_string (Llvm.string_of_llmodule result)*)
(*let result =  Codegen.translate ast in print_string("hi")*)
  (*print_string (Llvm.string_of_llmodule result)*)
