open Ast

type wildcard = Wildcard of string

type datatype = Datatype of primitive
		| Special of wildcard

type sformal = SFormal of datatype * string

type sfun_decl = {
	sreturn_typ : datatype;
	sfunc_typ   : func_type;
	sfunc_name  : string;
	sformals    : sformal list;
}

and sexpr =
	| SLiteral of sliteral
	| SId of string * datatype 
	| SBinop of sexpr * op * sexpr* datatype
	| SUniop of sexpr * uniop * datatype
	| SCall of string * sexpr list * datatype * int
	| SIf of sexpr * sexpr * sexpr
	| SEvaluate of sfun_def * sexpr 
	| SAss of sexpr_def * sexpr * datatype
	| SMatch of sexpr * datatype * smatch_case list

and sliteral = 
	| SInt_Lit of int
	| SFloat_Lit of float
	| SChar_Lit of int
	| SString_Lit of string
	| SBool_Lit of bool
	| SUnit

and sfun_def = SFun_Def of sfun_decl * sexpr list

and sexpr_def = SExpr_Def of datatype * string * sexpr 
	| SList_Def of datatype * string * slist_substance
	 
and slist_substance = SNewList of sexpr list
	| SPrepend of string * string

and smatch_case = SMatchCase of sexpr * datatype * sexpr * datatype

and sstmt = 
	| SFun_Def_Stmt of sfun_def
	| SAss_Stmt of sexpr_def
	| SExpr_Stmt of sexpr

type sprogram = SProgram of sstmt list
