/* Ocamlyacc parser for tail */
%{ open Ast %}

/*keywords*/
%token LET FUNC REC FUN ITER
%token IN
%token IF THEN ELSE
%token MATCH WITH

/*key symbols*/ 
%token PLUS MINUS MULT DIV MOD EQ NEQ LOG_AND OR NOT LESS GREATER GEQ LEQ
%token FPLUS FMINUS FMULT FDIV FLESS FLEQ FGREATER FGEQ
%token EOF
%token ASSIGN COMMA SEMIS SEMICOLON COLON COLONS
%token LPAREN RPAREN LBRACKET RBRACKET
%token RARROW BAR
%token WILDCARD

/*data types, literals, id*/
%token <int> INT_LITERAL
%token <int> CHAR_LITERAL
%token <float> FLOAT_LITERAL
%token <string> STRING_LITERAL
%token <bool> BOOL_LITERAL
%token INT STRING CHAR FLOAT BOOL
%token <string> ID

%nonassoc ELSE
%right BAR
%nonassoc RARROW
%right IN
%nonassoc SEMICOLON
%right ASSIGN
%left LOG_AND OR
%left EQ NEQ
%left GEQ LEQ LESS GREATER
%left PLUS MINUS
%left MULT DIV MOD
%right NOT

%start program
%type <Ast.program> program

%%

program:
     stmt_list EOF { Program(List.rev $1) }

stmt_list:
     stmt { [$1] }
     | stmt_list stmt { $2::$1 }

stmt:
     fun_def SEMICOLON		{ Fun_Def_Stmt($1) }	
     | expr_def SEMICOLON	{ Ass_Stmt($1) }
     | expr SEMICOLON		{ Expr_Stmt($1)	}
	
type_decl: 
     primitive { $1 }

primitive:    
     INT        	 { Int_Decl }
     | FLOAT    	 { Float_Decl }
     | CHAR     	 { Char_Decl }
     | STRING 		 { String_Decl }
     | BOOL     	 { Bool_Decl }

expr:
     exprs		{ $1 }
     | defs		{ $1 }
     | conds		{ $1 }
     | match_expr	{ $1 }

exprs:
     literal 				{ Literal($1) }
     | ID				{ Id($1) }
     | LPAREN expr RPAREN 		{ Expr($2) }
     | expr PLUS expr    		{ Binop($1, Add, $3) }
     | expr MINUS expr   		{ Binop($1, Minus, $3) }
     | expr MULT expr   		{ Binop($1, Mult, $3) }
     | expr DIV expr     		{ Binop($1, Div, $3) }
     | expr MOD expr     		{ Binop($1, Mod, $3) }
     | expr EQ expr      		{ Binop($1, Eq, $3) }
     | expr NEQ expr     		{ Binop($1, Neq, $3) }
     | expr GEQ expr     		{ Binop($1, Geq, $3) }
     | expr LEQ expr     		{ Binop($1, Leq, $3) }
     | expr LESS expr    		{ Binop($1, Less, $3) }
     | expr GREATER expr 		{ Binop($1, Greater, $3) }
     | expr LOG_AND expr 		{ Binop($1, Log_And, $3) }
     | expr OR expr			{ Binop($1, Or, $3) }
     | NOT expr 			{ Uniop($2, Not) }
     | ID LPAREN actuals_opt RPAREN 	{ Call($1, $3) }
     /*| items_opt			{ $1 }*/
    
conds:
     | IF expr THEN expr ELSE expr 	{ If($2, $4, $6) }

defs:
     | fun_def IN expr			{ Evaluate($1, $3)}
     | expr_def IN expr			{ Ass($1, $3) }

fun_decl:
	| type_decl ID LPAREN formals_opt RPAREN
	    { {	return_typ = $1;
		func_typ = Iter;
		func_name = $2;
		formals = $4 } }
	| type_decl REC ID LPAREN formals_opt RPAREN
	    { {	return_typ = $1;
		func_typ = Rec;
		func_name = $3;
		formals = $5 } }
fun_def:
	| LET fun_decl ASSIGN FUN expr_list SEMICOLON 	{Fun_Def($2, $5)}

expr_def:
     | LET type_decl ID ASSIGN expr	{ Expr_Def($2, $3, $5) }
     | LET type_decl LBRACKET RBRACKET ID ASSIGN list_substance {List_Def($2, $5, $7) }

list_substance:
     | LBRACKET items_opt RBRACKET { NewList($2) }
     | ID COLONS ID		   { Prepend($1, $3) }

items_opt:
     /*empty*/	 {[]}
     | item_list { List.rev $1 }

item_list:
     expr				{ [$1] }
     | item_list SEMICOLON expr 	{ $3::$1 }

actuals_opt:
	{[]}				
	| actuals_list { List.rev $1 }

actuals_list:
	expr	{[$1]}
	| actuals_list COMMA expr { $3::$1 }

expr_list:
     expr 				{ [$1] }
     | expr_list SEMICOLON expr 	{ $3::$1 }

literal:
     INT_LITERAL      	 { Int_Lit($1)   }
     | FLOAT_LITERAL     { Float_Lit($1) }
     | CHAR_LITERAL      { Char_Lit($1)  }
     | STRING_LITERAL    { String_Lit($1)}
     | BOOL_LITERAL      { Bool_Lit($1)  }
     | LPAREN RPAREN     { Unit        }
     | LBRACKET RBRACKET { Unit        }

formals_opt:
     /* nothing */ 	{[]}
     | formal_list 	{ List.rev $1 }

formal_list:
     formal_arg		{ [$1] }
     | formal_list COMMA formal_arg { $3::$1 }

formal_arg: 
     type_decl ID 	{ Formal($1, $2) }

match_expr:
     MATCH expr WITH match_list { Match ($2, $4) }

match_list:
     wildcard			     { [$1] }
     | match_case BAR match_list     { $1::$3 }

wildcard:
     WILDCARD RARROW expr	{ MatchCase(Literal(String_Lit("_")), $3) }

match_case:
     exprs RARROW expr { MatchCase($1, $3) }

