(* Code generation: translate takes a semantically checked AST and
produces LLVM IR

http://llvm.moe/
http://llvm.moe/ocaml/

*)

open Llvm
open Ast
open Sast
open RobotsInDisguise
open Exceptions
module StringMap = Map.Make(String)


let translate env =

    (* Stuff for main & includes *)
    let include_stdio = "#include <stdio.h>\n\n" in 
    let include_string = "#include <string.h>\n\n" in 
    let includes = include_stdio ^ include_string in

    let main_str = "int main(){\n" in
    let main_end = "\n}\n" in

    (* Unwrap the vars and funcs from robot *)
    let vars = env.vars in 
    let vars_order = List.rev env.vars_order in
    let funs = env.funs in
    let funs_order = List.rev env.funs_order in
    let ees = env.expressions in
    
    (* returns string of type *)
    let match_type dtype = 
        match dtype with
        | Datatype(Int_Decl) -> "int"
        | Datatype(Float_Decl) -> "float"
        | Datatype(Bool_Decl) -> "int"
        | Datatype(Char_Decl) -> "char"
        | Datatype(String_Decl) -> "char*"
        | _ -> "void"
    in 
  
    (* Converts literals to string representation *)        
    let string_of_sliteral l = match l with
        | SInt_Lit(i) -> string_of_int i
        | SFloat_Lit(f) -> string_of_float f
        | SChar_Lit(i) -> string_of_int i
        | SString_Lit(s) -> "\"" ^ s ^ "\""
        | SBool_Lit(b) -> (if (b = true) then "1" else "0")
        | SUnit -> "void"
    in 
    
    let string_of_uniop u = match u with
        | Not -> "!"
    in
 
    (* Function that recursively converts expressions into strings *)	
    let rec string_of_expr expression v f =
	match expression with
	| SLiteral(l) -> string_of_sliteral l
	| SId(var_name, dtype) -> ignore (resolveScope var_name dtype v f); var_name
	| SBinop(e1, o, e2, dtype) -> "(" ^ (string_of_expr e1 v f) ^ ") " 
                                ^ (string_of_op o) ^ " (" 
                                ^ (string_of_expr e2 v f) ^") "
	| SUniop(e, u, dtype) -> (string_of_uniop u)^" ("^(string_of_expr e v f)^") "
	| SCall(funcname, sexprList, dtype, _) -> 
		(match funcname with
			| "print_int" -> "printf(\"%d\\n\", "^(string_of_actuals sexprList v f)^")"
			| "print_float" -> "printf(\"%f\\n\", "^(string_of_actuals sexprList v f)^")"
			| "print_bool" -> "printf(\"%d\\n\", "^(string_of_actuals sexprList v f)^")"
			| "print_char" -> "printf(\"%c\\n\", "^(string_of_actuals sexprList v f)^")"
			| "print_string" -> "printf(\"%s\\n\", "^(string_of_actuals sexprList v f)^")"
			| _ -> 
				ignore (functionCall funcname sexprList v f); 
				funcname ^ "(" ^(string_of_actuals sexprList v f) ^") ")
	| SIf(cond, texpr, fexpr) -> "if ("^(string_of_expr cond v f) ^ ") {\n" 
                                        ^ (string_of_expr texpr v f) ^ ";\n}\nelse {\n" 
                                        ^ (string_of_expr fexpr v f) ^";\n}"
	| SEvaluate(sfunDef, se) -> string_of_expr (evalE sfunDef se v f) v f
	| SAss(sexprDef, se, dtype) -> ignore(evalAss sexprDef se v f); 
                (*match se with
                | SMatch(pattern, dtype, caseList) -> build_match_assign pattern se dtype caseList v f 
                | _ -> (string_of_sexpr_def sexprDef v f)^";\n"^(string_of_expr se (strmap sexprDef v f) f)*)
                (string_of_sexpr_def sexprDef v f) ^ ";\n" ^ (string_of_expr se (strmap sexprDef v f) f)
	| SMatch(pattern, dtype, caseList) -> build_match pattern dtype caseList v f
	| _ -> raise (Exceptions.OperationNotPermitted "Match not permitted")

    and string_of_sexpr_def sd v f=
        match sd with
        | SExpr_Def(dtype, name, se) -> (match_type dtype)^" "^name^" = "^(string_of_expr se v f)
        | _ -> "You turd."

    and string_of_actuals sl v f =
        match sl with
        | [] -> ""
        | [s] -> string_of_expr s v f
        | s::l -> (string_of_actuals l v f)^", "^(string_of_expr s v f)

    and strmap s v f =
        match s with
        | SExpr_Def(dtype, n, se) -> StringMap.add n { 
                data_type = dtype; 
                name = n; 
                value = (evalExpr se v f); } v
        | _ -> v

    and  build_match_num caseList v f = 
        let rec helper str = function
            [SMatchCase(_,_,e,_)] -> e, str
            | SMatchCase(e1,d1,e2,d2) :: tl ->
                let str' = str ^ "case(" 
                               ^ (string_of_expr e1 v f) ^ ") :\n\t " 
                               ^ (string_of_expr e2 v f) ^ ";\n\t break;\n"
            in helper str' tl
        in
	let cl = (List.rev caseList) in
        let final_e, case_str = helper "" cl in 
        case_str ^ "\t default :\n\t" ^ (string_of_expr final_e v f) ^ ";\n"    

    and build_match pattern dtype caseList v f = 
        match dtype with 
        | Datatype(Int_Decl) -> 
            let switchstmt = "switch(" ^ (string_of_expr pattern v f) ^ "){\n\t" in
            let end_switch = "}\n" in
            switchstmt ^ (build_match_num caseList v f) ^ end_switch
        (*| Datatype(Float_Decl) | Datatype(Bool_Decl) -> *)
        (*| Datatype(Char_Decl) | Datatype(String_Decl) -> build_match_str pattern caseList v f*)
        | _ -> raise (Exceptions.InvalidMatch "Cannot match on a void value.")
    
    and  build_match_num_assign variable caseList v f = 
        let rec helper str = function
            [SMatchCase(_,_,e,_)] -> e, str
            | SMatchCase(e1,d1,e2,d2) :: tl ->
                let str' = str ^ "case(" 
                               ^ (string_of_expr e1 v f) ^ ") :\n\t " 
                               ^ (string_of_expr variable v f) ^ " = "  
                               ^ (string_of_expr e2 v f) ^ ";\n\t break;\n"
            in helper str' tl
        in
	let cl = (List.rev caseList) in
        let final_e, case_str = helper "" cl in 
        case_str ^ "\t default :\n\t" ^ (string_of_expr final_e v f) 
    
    and build_match_assign pattern variable dtype caseList v f = 
        match dtype with 
        | Datatype(Int_Decl) -> 
            let switchstmt = "0;\n switch(" ^ (string_of_expr pattern v f) ^ "){\n\t" in
            let end_switch = "}\n" in
            switchstmt ^ (build_match_num_assign variable caseList v f) ^ end_switch
        (*| Datatype(Float_Decl) | Datatype(Bool_Decl) -> *)
        (*| Datatype(Char_Decl) | Datatype(String_Decl) -> build_match_str pattern caseList v f*)
        | _ -> raise (Exceptions.InvalidMatch "Cannot match on a void value.")
 
    in
    
    
    (* Functions to build variable assign *)
    let match_value v = 
	match v with
        | SLiteral(SInt_Lit(i)) -> string_of_int i
        | SLiteral(SFloat_Lit(f)) -> string_of_float f
        | SLiteral(SBool_Lit(b)) -> (if (b = true) then (string_of_int 1) else (string_of_int 0))
        | SLiteral(SChar_Lit(c)) -> string_of_int c
        | SLiteral(SString_Lit(s)) -> s
	| SBinop(e1,o,e2,dtype) -> ((string_of_expr e1 vars funs)^" "^(string_of_op o)^" "^(string_of_expr e2 vars funs))
	| SUniop(se, u, dtype) -> (string_of_uniop u)^(string_of_expr se vars funs)
        | _ -> print_endline("shit");" "
    in

    (* Generate global vars *)
    let add_vars acc n =
	let v_s = StringMap.find n vars in
	let name = v_s.name in
	let typ = match_type v_s.data_type in
	let value = match_value v_s.value in
	acc^typ^" "^name^" = "^value ^";\n"
    in
        
    let global_vars = List.fold_left add_vars "" vars_order in

    (* Make formal parameters string *)
    let rec string_of_formals_list fl = 
        match fl with
        | [] -> ""
        | [SFormal(dtype, name)] -> (match_type dtype)^" "^name
        | SFormal(dtype, name)::l -> (match_type dtype)^" "^name^", "^(string_of_formals_list l)
    in 
    
    (* Make expression strings *)
    let rec string_of_expr_list el formal_list =
	let rec addVars fl v = match fl with
            | [] -> v
            | [SFormal(p, n)] -> 
                    StringMap.add n { data_type = p; name = n; value = SLiteral(SInt_Lit(1)); } v
            | SFormal(p, n)::l -> let blah = StringMap.add n {
                                    data_type = p;
                                    name = n;
                                    value = SLiteral(SInt_Lit(1)); 
                            } v in (addVars l blah)
	in
	let newvar_map = addVars formal_list vars in
            match el with
            | [] -> ""
            | [e] -> (match e with 
                        | SAss(sexprDef, se, dtype) -> 
                                ignore(evalAss sexprDef se newvar_map funs); 
                                (string_of_sexpr_def sexprDef newvar_map funs) ^ ";\nreturn " 
                                ^ (string_of_expr se (strmap sexprDef newvar_map funs) funs)
                        | SIf(cond, texpr, fexpr) -> "if (" ^ (string_of_expr cond newvar_map funs) ^ ") {\n return " 
                                            ^ (string_of_expr texpr newvar_map funs) ^ ";\n}\nelse {\n return " 
                                            ^ (string_of_expr fexpr newvar_map funs) ^ ";\n}"
                        | _ -> "return " ^ (string_of_expr e newvar_map funs)) ^ ";"
            | e::l -> (match e with 
			| SIf(cond, texpr, fexpr) -> (string_of_expr e newvar_map funs) ^ "\n"
			| _ -> (string_of_expr e newvar_map funs) ^ ";\n" ^ (string_of_expr_list l formal_list))
    in 
    
    (* Make function declarations from list of fun structs *)
    let fun_list = List.fold_left (fun acc n -> let f_s = StringMap.find n funs in
						let ret_typ = match_type f_s.return_typ in
						let func_name = f_s.func_name in
						let formals = (string_of_formals_list f_s.formals) in
						let expr_list = (string_of_expr_list f_s.expr_list f_s.formals) in
		        			acc^"\n"^ret_typ^" "^func_name^" ("^formals^") {\n"^expr_list^"\n}")
						"" funs_order
   in 
	
    let s_ees = (string_of_expr_list (List.rev (SLiteral(SInt_Lit(0))::(ees))) []) in

    let the_string = includes ^ global_vars ^"\n"^ fun_list ^"\n"^ main_str ^ s_ees ^ main_end

in the_string

