#include <iostream>
#include "vlc.hpp"

int BLOOM_SIZE=32;
int KILO=1024;
int PASSES=1;
VLC_Array<int> bloom_filt_seq= VLC_Array<int>(32,1,32);
VLC_Array<int> bloom_filt_gpu= VLC_Array<int>(32,1,32);
VLC_Array<int> test_vals= VLC_Array<int>(1024,1,1024);
int MAX=10000;
void random_fill(VLC_Array<int>filt,int size,int max){
int i;
for(i=0;i < size;i=(i + 1)){
filt.set_element_value(rand(),1);
}
}




int hash(int in){
int shifted=(in >> 22);
return (in ^ shifted);
}




void set_index(VLC_Array<int>filt,int i){
filt.set_element_value(((1 << (i % 32)) | (filt.get_element_value(1,(i / 32)))),1);
}




int test_index(VLC_Array<int>filt,int i){
return ((filt.get_element_value(1,(i / 32))) & (1 << (i % 32))) != 0;
}




int vlc(){
int test_size=(PASSES * KILO);
random_fill(test_vals,test_size,MAX);
int index;
int seq_counter;
int seq_def_not;
int result;
int i;
printf("Starting sequential...");
for(i=0;i < test_size;i=(i + 1)){
bool divis=(i % 2);
if(divis == true){
index=hash((test_vals.get_element_value(1,i)));
set_index(bloom_filt_seq,index);
(seq_counter++);
}
else{
index=hash((test_vals.get_element_value(1,i)));
result=test_index(bloom_filt_seq,index);
if(result == 0){
(seq_def_not++);
}
}
}
return 0;
}


int main(void) { return vlc(); }