type token =
  | LPAREN
  | RPAREN
  | LBRACKET
  | RBRACKET
  | LCURLY
  | RCURLY
  | INDENT
  | DEDENT
  | COLON
  | TERMINATOR
  | EOF
  | COMMA
  | DEF
  | DEFG
  | RETURN
  | CONSTS
  | TILDA
  | DEDENT_EOF of (int)
  | DEDENT_COUNT of (int)
  | ADD
  | SUBTRACT
  | MULTIPLY
  | DIVIDE
  | MODULO
  | PLUS_PLUS
  | MINUS_MINUS
  | BITSHIFT_RIGHT
  | BITSHIFT_LEFT
  | AND
  | OR
  | NOT
  | XOR
  | EQUAL
  | NOT_EQUAL
  | GREATER_THAN
  | GREATER_THAN_EQUAL
  | LESS_THAN
  | LESS_THAN_EQUAL
  | IF
  | ELSE
  | WHILE
  | FOR
  | CONTINUE
  | BREAK
  | BITWISE_AND
  | BITWISE_OR
  | ASSIGNMENT
  | INTEGER_LITERAL of (int)
  | STRING_LITERAL of (string)
  | FLOATING_POINT_LITERAL of (float)
  | BOOLEAN_LITERAL of (bool)
  | IDENTIFIER of (string)
  | DATATYPE of (string)

val program :
  (Lexing.lexbuf  -> token) -> Lexing.lexbuf -> Ast.program
