open Ast
module S = Semant

let clean ast =

  let rm_nost type_list =
    let type_remove_rec original element = match element with
      | Ast.Nostmt -> original
      | _ -> List.append original [element] in
    List.fold_left type_remove_rec [] type_list in
  let change_function_statment k = 
    { Ast.typ = k.Ast.typ; 
      Ast.fname = k.Ast.fname;
      Ast.formals = k.Ast.formals;
      Ast.fbody = { Ast.f_vdecls = k.fbody.Ast.f_vdecls;  
                Ast.f_stmts = rm_nost k.fbody.Ast.f_stmts}} 
  in
  (* Convert global variables to assignemnt statements *)
  let edit_globals g_list = 
    let create_stmt vdecl = match vdecl with 
      (_, n, e) -> Ast.Expr (Ast.Assign (n, e))
    in
    let rec helper g c = match g with
        [] -> c 
      | hd :: tl -> helper tl (create_stmt hd :: c);            
    in helper g_list []
  in

  let statements = fst (fst ast) in
  let globals = snd (fst ast) in
  let functions = fst (snd ast) in
  let classes = snd (snd ast) in
  let no_stmt_functions = List.map change_function_statment functions in  
  ((statements, globals), (* Statements and globals *)
  ((List.append [{  Ast.typ = Ast.None; 
                    fname   = "main"; 
                    formals = []; 
                    fbody   = { Ast.f_vdecls = []; (* empty: this way it doesn't affect scope of globals *)
                              f_stmts = edit_globals globals @ List.rev (rm_nost statements)}}] 
                no_stmt_functions), (* Functions *)
    classes)) (* Classes *)


