let a = Hashtbl.create 1;;
Hashtbl.add a "test" 10;;
Hashtbl.add a "test2" 11;;

Hashtbl.find a "test";;

let b = Hashtbl.create 1;;
Hashtbl.add b "test3" 12;;
Hashtbl.add b "test3" 100;;
Hashtbl.add b "test3" 101;;
Hashtbl.add b "test4" 13;;

let test_lst = [];;

let test_lst = (Hashtbl.copy a) :: (Hashtbl.copy b) :: test_lst;;

let rec find_elem s = function
	hd :: sl -> if (Hashtbl.mem hd s) then Hashtbl.find hd s
				else find_elem s sl
	| [] -> raise Not_found
;;

let combine_hashes from_hash to_hash = 
	Hashtbl.iter (fun key value -> Hashtbl.add to_hash key value) from_hash	


let string_of_hash tbl = 
	Hashtbl.fold (fun key value init -> "{" ^ key ^ ": " ^ string_of_int(value) ^ "} " ^ init) tbl "";;

let print_hash tbl = 
	let string_of_list lst =
		"[" ^ (List.fold_left (fun res elem -> res ^ " " ^ string_of_int(elem)) "" lst) ^ " ]"
	in
	Hashtbl.iter (fun key value -> print_string ("{ " ^ key ^ ": " ^ (string_of_list val) ^ " }")) tbl;;

let a = (0 :: a) in List.length a;;

let type_checking a = 
	match a with
	| t1 -> t1

type_checking (Array(Int, 1));;

type_checking (Matrix(2, 1)) == type_checking (Matrix(2, 1)) ;;

type_checking Char == type_checking Char ;;


type typ = Int | Bool | Char | Array of typ * int | Pic | Void | Matrix of int * int


String.equal "mat 5" "mat 5 ";;