/*
 * Decompiled with CFR 0.152.
 */
package com.giaybac.traprange.entity;

import com.giaybac.traprange.entity.TableCell;
import com.giaybac.traprange.entity.TableRow;
import java.util.ArrayList;
import java.util.List;

public class Table {
    private final int pageIdx;
    private final List<TableRow> rows = new ArrayList<TableRow>();
    private final int columnsCount;

    public Table(int idx, int columnsCount) {
        this.pageIdx = idx;
        this.columnsCount = columnsCount;
    }

    public int getPageIdx() {
        return this.pageIdx;
    }

    public List<TableRow> getRows() {
        return this.rows;
    }

    public String toHtml() {
        StringBuilder retVal = new StringBuilder();
        retVal.append("<!DOCTYPE html><html><head><meta charset='utf-8'>").append("</head>").append("<body>");
        retVal.append("<table border='1'>");
        for (TableRow row : this.rows) {
            retVal.append("<tr>");
            int cellIdx = 0;
            int columnIdx = 0;
            while (columnIdx < this.columnsCount && cellIdx < row.getCells().size()) {
                TableCell cell = row.getCells().get(cellIdx);
                if (cell.getIdx() == columnIdx) {
                    retVal.append("<td>").append(cell.getContent()).append("</td>");
                    ++cellIdx;
                    ++columnIdx;
                    continue;
                }
                if (columnIdx < cellIdx) {
                    retVal.append("<td>").append("</td>");
                    ++columnIdx;
                    continue;
                }
                throw new RuntimeException("Invalid state");
            }
            retVal.append("</tr>");
        }
        retVal.append("</table>").append("</body>").append("</html>");
        return retVal.toString();
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder();
        for (TableRow row : this.rows) {
            if (retVal.length() > 0) {
                retVal.append("\n");
            }
            retVal.append(row.toString());
        }
        return retVal.toString();
    }
}

