/*
 * Decompiled with CFR 0.152.
 */
package com.giaybac.traprange;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrapRangeBuilder {
    private final Logger logger = LoggerFactory.getLogger(TrapRangeBuilder.class);
    private final List<Range<Integer>> ranges = new ArrayList<Range<Integer>>();

    public TrapRangeBuilder addRange(Range<Integer> range) {
        this.ranges.add(range);
        return this;
    }

    public List<Range<Integer>> build() {
        ArrayList<Range<Integer>> retVal = new ArrayList<Range<Integer>>();
        Collections.sort(this.ranges, new Comparator<Range>(){

            @Override
            public int compare(Range o1, Range o2) {
                return o1.lowerEndpoint().compareTo(o2.lowerEndpoint());
            }
        });
        for (Range<Integer> range : this.ranges) {
            if (retVal.isEmpty()) {
                retVal.add(range);
                continue;
            }
            Range lastRange = (Range)retVal.get(retVal.size() - 1);
            if (lastRange.isConnected(range)) {
                Range<Integer> newLastRange = lastRange.span(range);
                retVal.set(retVal.size() - 1, newLastRange);
                continue;
            }
            retVal.add(range);
        }
        this.logger.debug("Found " + retVal.size() + " trap-range(s)");
        return retVal;
    }
}

