/*
 * Decompiled with CFR 0.152.
 */
package com.giaybac.traprange;

import com.giaybac.traprange.PDFTableExtractor;
import com.giaybac.traprange.entity.Table;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.primitives.Ints;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.PropertyConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MAIN {
    private static final Logger logger = LoggerFactory.getLogger(MAIN.class);

    public static void main(String[] args) {
        PropertyConfigurator.configure(MAIN.class.getResource("/com/giaybac/traprange/log4j.properties"));
        if (args.length == 1 && "-h".equals(args[0])) {
            MAIN.printHelp();
        } else {
            MAIN.extractTables(args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractTables(String[] args) {
        try {
            List<Integer> pages = MAIN.getPages(args);
            List<Integer> exceptPages = MAIN.getExceptPages(args);
            List<Integer[]> exceptLines = MAIN.getExceptLines(args);
            String in = MAIN.getIn(args);
            String out = MAIN.getOut(args);
            PDFTableExtractor extractor = new PDFTableExtractor().setSource(in);
            for (Integer page : pages) {
                extractor.addPage(page);
            }
            for (Integer exceptPage : exceptPages) {
                extractor.exceptPage(exceptPage);
            }
            ArrayList<Integer> exceptLineIdxs = new ArrayList<Integer>();
            LinkedListMultimap<Integer, Integer> exceptLineInPages = LinkedListMultimap.create();
            for (Integer[] exceptLine : exceptLines) {
                if (exceptLine.length == 1) {
                    exceptLineIdxs.add(exceptLine[0]);
                    continue;
                }
                if (exceptLine.length != 2) continue;
                int lineIdx = exceptLine[0];
                int pageIdx = exceptLine[1];
                exceptLineInPages.put(pageIdx, lineIdx);
            }
            if (!exceptLineIdxs.isEmpty()) {
                extractor.exceptLine(Ints.toArray(exceptLineIdxs));
            }
            if (!exceptLineInPages.isEmpty()) {
                Iterator<Object> iterator = exceptLineInPages.keySet().iterator();
                while (iterator.hasNext()) {
                    int pageIdx = (Integer)iterator.next();
                    extractor.exceptLine(pageIdx, Ints.toArray(exceptLineInPages.get(pageIdx)));
                }
            }
            List<Table> tables = extractor.extract();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(out), "UTF-8");
            try {
                for (Table table : tables) {
                    writer.write("Page: " + (table.getPageIdx() + 1) + "\n");
                    writer.write(table.toHtml());
                }
            }
            finally {
                try {
                    ((Writer)writer).close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            logger.error(null, e);
        }
    }

    private static void printHelp() {
        StringBuilder help = new StringBuilder();
        help.append("Argument list: \n").append("\t-in: (required) absolute pdf location path. Ex: \"/Users/thoqbk/table.pdf\"\n").append("\t-out: (required) absolute output file. Ex: \"/Users/thoqbk/table.html\"\n").append("\t-el: except lines. For example, to exept lines 1,2,3 and -1 (last line) in all pages and line 4 in page 8, the value shoud be: \"1,2,3,-1,4@8\"\n").append("\t-p: only parse these pages. Ex: 1,2,3\n").append("\t-ep: all pages except these pages. Ex: 1,2\n").append("\t-h: help\n").append("---");
        logger.info(help.toString());
    }

    private static List<Integer> getPages(String[] args) {
        return MAIN.getInts(args, "p");
    }

    private static List<Integer> getExceptPages(String[] args) {
        return MAIN.getInts(args, "ep");
    }

    private static List<Integer> getInts(String[] args, String name) {
        ArrayList<Integer> retVal = new ArrayList<Integer>();
        String intsInString = MAIN.getArg(args, name);
        if (intsInString != null) {
            String[] intInStrings;
            for (String intInString : intInStrings = intsInString.split(",")) {
                try {
                    retVal.add(Integer.parseInt(intInString.trim()));
                }
                catch (Exception e) {
                    throw new RuntimeException("Invalid argument (-" + name + "): " + intsInString, e);
                }
            }
        }
        return retVal;
    }

    private static List<Integer[]> getExceptLines(String[] args) {
        String[] exceptLineStrings;
        ArrayList<Integer[]> retVal = new ArrayList<Integer[]>();
        String exceptLinesInString = MAIN.getArg(args, "el");
        if (exceptLinesInString == null) {
            return retVal;
        }
        for (String exceptLineString : exceptLineStrings = exceptLinesInString.split(",")) {
            if (exceptLineString.contains("@")) {
                String[] exceptLineItems = exceptLineString.split("@");
                if (exceptLineItems.length != 2) {
                    throw new RuntimeException("Invalid except lines argument (-el): " + exceptLinesInString);
                }
                try {
                    int lineIdx = Integer.parseInt(exceptLineItems[0].trim());
                    int pageIdx = Integer.parseInt(exceptLineItems[1].trim());
                    retVal.add(new Integer[]{lineIdx, pageIdx});
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Invalid except lines argument (-el): " + exceptLinesInString, e);
                }
            }
            try {
                int lineIdx = Integer.parseInt(exceptLineString.trim());
                retVal.add(new Integer[]{lineIdx});
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid except lines argument (-el): " + exceptLinesInString, e);
            }
        }
        return retVal;
    }

    private static String getOut(String[] args) {
        String retVal = MAIN.getArg(args, "out", null);
        if (retVal == null) {
            throw new RuntimeException("Missing output location");
        }
        return retVal;
    }

    private static String getIn(String[] args) {
        String retVal = MAIN.getArg(args, "in", null);
        if (retVal == null) {
            throw new RuntimeException("Missing input file");
        }
        return retVal;
    }

    private static String getArg(String[] args, String name, String defaultValue) {
        int argIdx = -1;
        for (int idx = 0; idx < args.length; ++idx) {
            if (!("-" + name).equals(args[idx])) continue;
            argIdx = idx;
            break;
        }
        if (argIdx == -1) {
            return defaultValue;
        }
        if (argIdx < args.length - 1) {
            return args[argIdx + 1].trim();
        }
        throw new RuntimeException("Missing argument value. Argument name: " + name);
    }

    private static String getArg(String[] args, String name) {
        return MAIN.getArg(args, name, null);
    }
}

