/*
 * Decompiled with CFR 0.152.
 */
package demo.orsoncharts.swing;

import com.orsoncharts.Chart3D;
import com.orsoncharts.Chart3DFactory;
import com.orsoncharts.Chart3DPanel;
import com.orsoncharts.axis.ValueAxis3D;
import com.orsoncharts.data.DefaultKeyedValues;
import com.orsoncharts.data.KeyedValues;
import com.orsoncharts.data.category.CategoryDataset3D;
import com.orsoncharts.data.category.StandardCategoryDataset3D;
import com.orsoncharts.graphics3d.Offset3D;
import com.orsoncharts.graphics3d.ViewPoint3D;
import com.orsoncharts.graphics3d.swing.DisplayPanel3D;
import com.orsoncharts.graphics3d.swing.Panel3D;
import com.orsoncharts.label.CategoryItemLabelGenerator;
import com.orsoncharts.label.ItemLabelPositioning;
import com.orsoncharts.label.StandardCategoryItemLabelGenerator;
import com.orsoncharts.plot.CategoryPlot3D;
import com.orsoncharts.renderer.category.LineRenderer3D;
import demo.orsoncharts.swing.DemoPanel;
import demo.orsoncharts.swing.ExitOnClose;
import demo.orsoncharts.swing.OrsonChartsDemo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.geom.Dimension2D;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AxisRangeDemo3
extends JFrame {
    public AxisRangeDemo3(String string) {
        super(string);
        this.addWindowListener(new ExitOnClose());
        this.getContentPane().add(AxisRangeDemo3.createDemoPanel());
    }

    public static JPanel createDemoPanel() {
        CustomDemoPanel customDemoPanel = new CustomDemoPanel(new BorderLayout());
        customDemoPanel.setPreferredSize(OrsonChartsDemo.DEFAULT_CONTENT_SIZE);
        CategoryDataset3D categoryDataset3D = AxisRangeDemo3.createDataset();
        Chart3D chart3D = Chart3DFactory.createLineChart((String)"AxisRangeDemo3", (String)"A test for axis range changes on a line chart", (CategoryDataset3D)categoryDataset3D, (String)"Row", (String)"Category", (String)"Value");
        chart3D.setChartBoxColor(new Color(255, 255, 255, 128));
        chart3D.setViewPoint(ViewPoint3D.createAboveLeftViewPoint((double)40.0));
        CategoryPlot3D categoryPlot3D = (CategoryPlot3D)chart3D.getPlot();
        categoryPlot3D.getValueAxis().setRange(-500.0, 500.0);
        categoryPlot3D.getRowAxis().setVisible(false);
        LineRenderer3D lineRenderer3D = (LineRenderer3D)categoryPlot3D.getRenderer();
        lineRenderer3D.setItemLabelPositioning(ItemLabelPositioning.FRONT_AND_BACK);
        lineRenderer3D.setItemLabelOffsets(new Offset3D(0.0, 0.0, 1.2));
        lineRenderer3D.setItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator("%4$.2f"));
        Chart3DPanel chart3DPanel = new Chart3DPanel(chart3D);
        customDemoPanel.setChartPanel(chart3DPanel);
        customDemoPanel.add((Component)new DisplayPanel3D((Panel3D)chart3DPanel));
        chart3DPanel.zoomToFit((Dimension2D)OrsonChartsDemo.DEFAULT_CONTENT_SIZE);
        return customDemoPanel;
    }

    private static CategoryDataset3D createDataset() {
        StandardCategoryDataset3D standardCategoryDataset3D = new StandardCategoryDataset3D();
        DefaultKeyedValues defaultKeyedValues = new DefaultKeyedValues();
        defaultKeyedValues.put((Comparable)((Object)"A"), (Object)-500);
        defaultKeyedValues.put((Comparable)((Object)"B"), (Object)-200);
        defaultKeyedValues.put((Comparable)((Object)"C"), (Object)-400);
        defaultKeyedValues.put((Comparable)((Object)"D"), (Object)-150);
        standardCategoryDataset3D.addSeriesAsRow((Comparable)((Object)"All Negative"), (KeyedValues)defaultKeyedValues);
        DefaultKeyedValues defaultKeyedValues2 = new DefaultKeyedValues();
        defaultKeyedValues2.put((Comparable)((Object)"A"), (Object)-500);
        defaultKeyedValues2.put((Comparable)((Object)"B"), (Object)500);
        defaultKeyedValues2.put((Comparable)((Object)"C"), (Object)0);
        defaultKeyedValues2.put((Comparable)((Object)"D"), (Object)-150);
        standardCategoryDataset3D.addSeriesAsRow((Comparable)((Object)"Alternating 1"), (KeyedValues)defaultKeyedValues2);
        DefaultKeyedValues defaultKeyedValues3 = new DefaultKeyedValues();
        defaultKeyedValues3.put((Comparable)((Object)"A"), (Object)500);
        defaultKeyedValues3.put((Comparable)((Object)"B"), (Object)-500);
        defaultKeyedValues3.put((Comparable)((Object)"C"), (Object)0);
        defaultKeyedValues3.put((Comparable)((Object)"D"), (Object)150);
        standardCategoryDataset3D.addSeriesAsRow((Comparable)((Object)"Alternating 2"), (KeyedValues)defaultKeyedValues3);
        DefaultKeyedValues defaultKeyedValues4 = new DefaultKeyedValues();
        defaultKeyedValues4.put((Comparable)((Object)"A"), (Object)500);
        defaultKeyedValues4.put((Comparable)((Object)"B"), (Object)200);
        defaultKeyedValues4.put((Comparable)((Object)"C"), (Object)400);
        defaultKeyedValues4.put((Comparable)((Object)"D"), (Object)150);
        standardCategoryDataset3D.addSeriesAsRow((Comparable)((Object)"All Positive"), (KeyedValues)defaultKeyedValues4);
        return standardCategoryDataset3D;
    }

    public static void main(String[] stringArray) {
        AxisRangeDemo3 axisRangeDemo3 = new AxisRangeDemo3("OrsonCharts: AxisRangeDemo3.java");
        axisRangeDemo3.pack();
        axisRangeDemo3.setVisible(true);
    }

    static class CustomDemoPanel
    extends DemoPanel
    implements ChangeListener {
        private JSlider slider1 = new JSlider(-1000, 0);
        private JSlider slider2;

        public CustomDemoPanel(LayoutManager layoutManager) {
            super(layoutManager);
            this.slider1.setValue(-500);
            this.slider2 = new JSlider(0, 1000);
            this.slider2.setValue(500);
            this.slider1.addChangeListener(this);
            this.slider2.addChangeListener(this);
            JPanel jPanel = new JPanel(new FlowLayout());
            jPanel.add(new JLabel("Lower bound: "));
            jPanel.add(this.slider1);
            jPanel.add(new JLabel("Upper bound: "));
            jPanel.add(this.slider2);
            this.add((Component)jPanel, "South");
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            int n;
            Chart3D chart3D = (Chart3D)this.getChartPanel().getDrawable();
            CategoryPlot3D categoryPlot3D = (CategoryPlot3D)chart3D.getPlot();
            ValueAxis3D valueAxis3D = categoryPlot3D.getValueAxis();
            int n2 = this.slider1.getValue();
            if (n2 != (n = this.slider2.getValue())) {
                valueAxis3D.setRange((double)n2, (double)n);
            }
        }
    }
}

