(* signed: Yanlin Duan, Zhuo Kong *)

(* Top-level of the rusty compiler: scan & parse the input,
   check the resulting AST, generate LLVM IR, and dump the module *)

type action = Compile

let _ =
  let action = Compile in
  let lexbuf = Lexing.from_channel stdin in
  let ast = Parser.program Scanner.token lexbuf in
  let ast = Pre_semant.check ast in
  let sast = Semant.check ast in
  match action with
    Compile -> let m = Codegen.translate sast in
    Llvm_analysis.assert_valid_module m;
    print_string (Llvm.string_of_llmodule m)
