(* signed: Emily Meng *)

open Ast

module StringHash = Hashtbl.Make(struct
    type t = string (* type of keys *)
    let equal x y = x = y (* use structural comparison *)
    let hash = Hashtbl.hash (* generic hash function *)
end)

(* Preprocessing AST before passing to actual semant checker *)
(* ImplDef nodes converted into functions and removed from AST *)
(* StructMethodCall nodes converted into Call nodes *)

let check (functions) =

  let varMap = StringHash.create 20 in
  let implMap = StringHash.create 20 in
  let structMap = StringHash.create 20 in
  
  let check_function func =

    let rec expr_to_expr = function
        Noexpr                        -> Noexpr
      | IntLit(n)                     -> IntLit(n)
      | BoolLit(b)                    -> BoolLit(b)
      | FloatLit(f)                   -> FloatLit(f)
      | CharLit(c)                    -> CharLit(c)
      | StringLit(s)                  -> StringLit(s)
      | ArrayLit(exp)                 -> ArrayLit(exp)
      | Id(s)                         -> Id(s)
      | ArrayAccess(e1, e2)           -> ArrayAccess(e1, e2)
      | StructCreate(field_decl_list) -> StructCreate(field_decl_list)
      | StructAccess(e, s)            -> StructAccess(e, s)
      | StructMethodCall(s1, s2, el)  -> 
        (* convert method call name to struct_name+method_name ex. f.sumXY to PointSumXY *)
        let struct_type =  StringHash.find varMap s1 in
          let new_fn_name = struct_type ^ s2 in
          (* pass in self as variable to actuals_list *)
          let new_fn_actuals = Id(s1) :: el in 
            Call(new_fn_name, new_fn_actuals) 
      | Unop(o, e) -> Unop(o, e)
      | Cast(e, t) -> Cast(e, t)
      | Binop(operand1, operator, operand2) -> Binop(operand1, operator, expr_to_expr operand2)
      | Call(fname, actuals) -> Call(fname, actuals)
      in

      let rec stmt_to_stmt = function
          Block(sl) -> 
          let p_sl = List.map(fun x -> stmt_to_stmt x) sl in
          Block(p_sl)
        | Expr(e) -> 
          let e' = expr_to_expr e in Expr(e')
        | Return(e)                 -> Return(e)
        | If(p, b1, b2)             -> If(p, b1, b2)
        | While(p, s)               -> While(p, s)
        | For(e1, e2, e3, st)       -> For(e1, e2, e3, st)
        | Declaration(b, (s, t), e) ->
          let t' = string_of_typ t in
          let e = expr_to_expr e in
            ignore(StringHash.add varMap s t'); 
            Declaration(b, (s, t), e)
        | StructDef(s, sl) -> 
            StringHash.replace structMap s sl; 
            StructDef(s,sl)
        | ImplDef(s, fdl) -> 
          (*convert impl definition to function *)
          (*let func_impl = convert_impldef_to_fdecl s fdl in*)

          let func_impl =  
            {
              (* impl Point { fn sumXY } -> fn PointsumXY *)
              fname = s ^ fdl.fname;
              (* arg list takes self as new arg in beginning *)
              formals = ("self", StructT(s)) :: fdl.formals;
              outputType = fdl.outputType;
              body = fdl.body;
            } in
            ignore(try StringHash.find structMap s
            with Not_found -> raise(Failure("Impl is associated with a non-defined struct!")));
            StringHash.add implMap (s ^ fdl.fname) func_impl;
            Expr(Noexpr)
        | _ -> Break

    and convert_fdecl_to_fdecl fdecl =
    {
      fname = fdecl.fname;
      formals = fdecl.formals;
      outputType = fdecl.outputType;
      body = List.map (fun x -> stmt_to_stmt x) fdecl.body;
    }

    in

    convert_fdecl_to_fdecl func

    in

    let func_list = List.map check_function functions in
    let list_arr = StringHash.fold (fun _ v l -> v :: l ) implMap [] in   
    let all = List.append func_list list_arr in
    all