module audio_effects (
input [15:0] apple,
input pad,
input clk,
input peng,
input sample_end,
input sample_req,
output [15:0] audio_output,
input [15:0] audio_input,
input [3:0] control,
output en,
output addr_r,
output continue_wr
);

sound_2 ti_ta(
	.clock(clk),
	.address(back_index),
	.q(audio_back_out)
);

reg continue;
reg [18:0] bg_address;
wire [15:0] bg_output;

DING ding(
	.clock(clk),
	.address(ding_index),
	.q(audio_ding_out)
);

qq QQ(
	.clock(clk),
	.address(qq_index),
	.q(audio_qq_out)
);


//logic [15:0] 			 mem [15:0];
reg [10:0] address_r;
reg ren;

wire [15:0] audio_sample_out;
wire [15:0] audio_back_out;
reg play=1'd1;
reg play_ding=1'd1;
reg [12:0] audio_index=13'd0;
reg [13:0] qq_index = 14'd0;
reg [13:0] back_index=14'd0;
reg [13:0] ding_index=14'd0;
wire [15:0] audio_ding_out;
wire [15:0] audio_qq_out;
reg [15:0] romdata [0:99];
reg [6:0] index = 7'd0;
reg [15:0] last_sample;
reg [15:0] dat;
assign audio_output = dat;
parameter SINE = 0;
parameter FEEDBACK = 1;
reg ding_ready;

always @(posedge clk) begin
if(peng)
		ding_ready<=1'b1;
if (ding_index==14'd10538) 
			ding_ready<=1'b0;

end
reg [31:0] count=0;
	always @(posedge clk) begin
	
		if (sample_end) begin
			last_sample <= audio_input;
		end
		if (sample_req) begin
		//control==4'b0100 || 
			if (peng || ding_index>14'b0 ) begin
				dat<=audio_ding_out;
				if (ding_index==14'd10538) begin
					ding_index<=14'd0;
					
	
				end else begin
			
					ding_index<=ding_index+1'd1;
				end
			end else if(pad || back_index>14'd0) begin	
				dat <= audio_back_out;
				if (back_index == 14'd11519) begin
					back_index <= 14'd00;
		//			play<=1'd0;
				end else begin
					back_index <= back_index + 1'b1;
					end 
				
			end else begin
	/*
				dat <= audio_qq_out;
				if (qq_index == 14'd5139) begin
					qq_index <= 14'd00;
		//			play<=1'd0;
				end else begin
					qq_index <= qq_index + 1'b1;
					end 
	*/	
			dat <= 16'd10551;
		end

			//		dat <= 16'd0;
	/*				
			if(control==4'b0010) begin
					ren <= 1'b1;
					dat<=apple; 
					if (address_r<=2046) begin
						address_r <= address_r +11'd1;
						continue <= 1'b0;
					end
					else begin
						continue <= 1'b1;
						address_r <= 11'd0;
					end
			end
		*/
			/*
			if (control==4'b1000) begin
				dat <= last_sample;
				play<=1'd1;
				play_ding<=1'd1;
			end else if (control[SINE]&&play) begin
				dat <= audio_back_out;
				if (back_index == 14'd11519) begin
					back_index <= 14'd00;
					play<=1'd0;
				end else
					back_index <= back_index + 1'b1;

			end else if(control==4'b0010) begin
					ren <= 1'b1;
					dat<=apple; 
					if (address_r<=2046) begin
						address_r <= address_r +11'd1;
						continue <= 1'b0;
					end
					else begin
						continue <= 1'b1;
						address_r <= 11'd0;
					end
			end
					*/
			 
	end //end of sample request
	
end
	assign en=ren;
	assign addr_r=address_r;
	assign continue_wr = continue;
	
	
endmodule