logic[2:0] letter_address;
logic inG;
logic inA;
logic inM;
logic inE1;
logic inO;
logic inV;
logic inE2;
logic inR;

logic[63:0] gameover_data;
logic gameover_output;

gameover_rom gameover_unit(
      .clock(clk50),
      .address({letter_address, vcount[5:0]}),
      .q(gameover_data)
);


always_comb begin
    inG = 0;
    inA = 0;
    inM = 0;
    inE1 = 0;
    inO = 0;
    inV = 0;
    inE1 = 0;
    inR = 0;
    if (hcount[10:1] > 191 && hcount[10:1] < 256 && vcount[9:0] > 127 && vcount[9:0] < 192) begin
         inG = 1;
         letter_address = 0;
    end
    else if (hcount[10:1] > 255 && hcount[10:1] < 320 && vcount[9:0] > 127 && vcount[9:0] < 192) begin
         inA = 1;
         letter_address = 1;
    end
    else if (hcount[10:1] > 319 && hcount[10:1] < 384 && vcount[9:0] > 127 && vcount[9:0] < 192) begin
         inM = 1;
         letter_address = 2;
    end
    else if (hcount[10:1] > 383 && hcount[10:1] < 448 && vcount[9:0] > 127 && vcount[9:0] < 192) begin
         inE1 = 1;
         letter_address = 3;
    end
    else if (hcount[10:1] > 191 && hcount[10:1] < 256 && vcount[9:0] > 191 && vcount[9:0] < 256) begin
         inO = 1;
         letter_address = 4;
    end
    else if (hcount[10:1] > 255 && hcount[10:1] < 320 && vcount[9:0] > 191 && vcount[9:0] < 256) begin
         inV = 1;
         letter_address = 5;
    end
    else if (hcount[10:1] > 319 && hcount[10:1] < 384 && vcount[9:0] > 191 && vcount[9:0] < 256) begin
         inE2 = 1;
         letter_address = 3;
    end
    else if (hcount[10:1] > 383 && hcount[10:1] < 448 && vcount[9:0] > 191 && vcount[9:0] < 256) begin
         inR = 1;
         letter_address = 6;
    end


end

assign gameover_output = gameover_data[~hcount[6:1]];

always_comb begin
      {VGA_R, VGA_G, VGA_B} = {8'd0, 8'd0, 8'd0}; // Black
      if (gameover_output && inG)
	        {VGA_R, VGA_G, VGA_B} = {8'd0, 8'd191, 8'd255}; // DeepSkyBlue
      else if (gameover_output && inA)
          {VGA_R, VGA_G, VGA_B} = {8'd0, 8'd255, 8'd0}; // Lime
	    else if (gameover_output && inM)
	        {VGA_R, VGA_G, VGA_B} = {8'd255, 8'd165, 8'd0}; // Orange
      else if (gameover_output && inE1)
          {VGA_R, VGA_G, VGA_B} = {8'd240, 8'd128, 8'd128}; // LightCoral
      else if (gameover_output && inO)
          {VGA_R, VGA_G, VGA_B} = {8'd255, 8'd182, 8'd193}; // LightPink
      else if (gameover_output && inV)
          {VGA_R, VGA_G, VGA_B} = {8'd255, 8'd105, 8'd180}; // HotPink
      else if (gameover_output && inE2)
          {VGA_R, VGA_G, VGA_B} = {8'd147, 8'd112, 8'd219}; // MidiumPurple
      else if (gameover_output && inR)
          {VGA_R, VGA_G, VGA_B} = {8'd0, 8'd255, 8'd127}; // SpringGreen
			 

end