module SPIKESORT(input logic	clk,
	       input logic 	  		reset,
	       input logic [15:0]  features,
	       input logic 	  		write,
	       input logic		  	chipselect,
			 input logic [5:0]  	op,//address
			 input logic			read,
//			 output logic			VALID,
	       output logic [15:0] 	sorterOut
			 //output logic [7:0]	Q_export
			 );

	// features
   logic [11:0]	spk_f;
	logic [2:0]		spk_idx;
	logic [41:0]	Bph;
	logic [6:0]		vph;
	logic [4:0]		commands;
	logic sel, clear, ker, laplace, fin, infm, update, leak, v_output;
	logic lp, upd, lp0, lp1, lp2, upd0, upd1, upd2;
	logic [7:0]		ocp;
	//logic [6:0] vph;
	
	//assign clear = commands[0];
	assign lp = commands[1];
	assign upd = commands[2];
	assign leak = commands[3];
	assign ker = commands[4];
	
	
	assign sorterOut[2:0] = spk_idx;
	assign sorterOut[4] = fin;
	assign sorterOut[3] = v_output;
	assign sorterOut[15:8] = (sel)?ocp:{vph,1'b0};
	
	//CTRL ctrlfsm(clk, start(reset), .ready(write), VALID, .*);
	DISTR memdistr(.init(reset), .addr(spk_f), .*);
	GC gcmod(.*);

//	CTRL ctrlfsm(clk, start, ready, fin, infm, v_output, done, init, clear, ker, laplace, update, leak, VALID);
//	DISTR memdistr(clk, .init(reset), clear, ker, laplace, addr, fin, infm, Bph, vph);
//	GC(reset, spk_f, Bph, vph, clk, update, leak, v_output, spk_idx);
	
   always_ff @(posedge clk) begin
     if (reset) begin
			spk_f <= 12'b000000000000;
     end else if (chipselect && write) begin
			spk_f <= {features[13:8], features[5:0]};
			commands <= op[4:0];
	  end
	  sel <= op[5];
	end
	
	always_ff @(posedge clk) begin
	  lp0 <= lp;
	  lp1 <= lp0;
	  lp2 <= lp1;
	  laplace <= lp2;
	  
	  upd0 <= upd;
	  upd1 <= upd0;
	  upd2 <= upd1;
	  update <= upd2;
	end
endmodule
