/* Andy Hunter
PLT Summer 15
Trix */

%{ open Ast %}

%token SEMI LPAREN RPAREN LBRACE RBRACE COMMA
%token PLUS MINUS TIMES DIVIDE ASSIGN
%token RETURN IF ELSE WHILE INT
%token FUNCTION 
%token <int> INT_LIT
%token <string> ID
%token EOF

%right ASSIGN
%left PLUS MINUS
%left TIMES DIVIDE
%nonassoc ELSE

%start program
%type <Ast.program> program

%%

datatype:
  | INT { Int }

expr:
  | ID { Id($1) }
  | INT_LIT { IntLiteral($1) }
  | expr PLUS expr { Binop($1, Add, $3) }
  | expr MINUS expr { Binop($1, Sub, $3) }
  | expr TIMES expr { Binop($1, Mult, $3) }
  | expr DIVIDE expr { Binop($1, Div, $3) }
  | ID ASSIGN expr { Assign($1, $3) }
  | ID LPAREN passed_args RPAREN { ApplyFunct($1, $3) }
 
passed_args:
  | expr                    { [$1] }
  | passed_args COMMA expr { $3 :: $1 }

stmt:
  | expr SEMI { Expr($1) }
  | RETURN expr SEMI { Return($2) }
  | LBRACE stmt_list RBRACE { Block(List.rev $2) }
  | IF LPAREN expr RPAREN stmt ELSE stmt { If($3, $5, $7) }
  | WHILE LPAREN expr RPAREN stmt { While($3, $5) }

stmt_list:
  | { [] }
  | stmt_list stmt  { $2 :: $1 }

vardef:
  | vardecl { VarDecl($1) }
  | varinit { Varinit($1) }

vardef_list:
  | { [] }
  | vardef_list vardef { $2 :: $1 }

vardecl:
  | datatype ID SEMI { {varname=$2;vartype=$1} }

varinit:
  | datatype ID ASSIGN expr SEMI { Vinit ( {varname = $2; vartype = $1} , $4) }

functdecl:
  | FUNCTION datatype ID LPAREN arg_list RPAREN LBRACE vardef_list stmt_list RBRACE
     { { ret = $2; name = $3; args = $5; locvars = $8; body = $9;} }

functdef:
  | datatype ID { {varname=$2; vartype = $1} }
  
arg_list:
  | { [] }
  | functdef	             { [$1] }
  | arg_list COMMA functdef  { $3 :: $1 }

program:
  | { [], [] }
  | program vardef { ($2 :: fst $1), snd $1 }
  | program functdecl { fst $1, ($2 :: snd $1) }
