(* Andy Hunter
PLT Summer 15
Trix *)

type op = Add | Sub | Mult | Div 

type dtype = Int

type var_decl = {varname: string; vartype: dtype}

type expr =
  | Id of string
  | IntLiteral of int
  | Binop of expr * op * expr
  | Assign of string * expr
  | ApplyFunct of string * expr list

type stmt =
  | Expr of expr
  | If of expr * stmt * stmt
  | While of expr * stmt
  | Block of stmt list
  | Return of expr

type var_init = 
  | Vinit of var_decl * expr

type var_def = 
  | Varinit of var_init
  | VarDecl of var_decl

type func_decl = {
    name : string;
    args : var_decl list;
    locvars : var_def list;
    body : stmt list;
    ret: dtype
  }

type program = var_def list * func_decl list

