#!/bin/sh

cd _build
NYCGCS="ocamlrun project.byte"

# Set time limit for all operations
ulimit -t 30

globallog=../tests/testall.log
rm -f $globallog
error=0
globalerror=0

keep=0

SignalError() {
    if [ $error -eq 0 ] ; then
	echo "FAILED"
	error=1
    fi
    echo "  $1"
}

# Run <args>
# Report the command, run it, and report any errors
Run() {
    echo $* 1>&2
    eval $* || {
	SignalError "$1 failed on $*"
	return 1
    }
}

Check() {
    error=0
    basename=`echo $1 | sed 's/.*\\///
                             s/.gs//'`
    reffile=`echo $1 | sed 's/.gs$//'`
    basedir="`echo $1 | sed 's/\/[^\/]*$//'`/."

    echo -n "$basename...\n"

    echo 1>&2
    echo "###### Testing $basename" 1>&2

    generatedfiles=""

    generatedfiles="$generatedfiles ${basename}.b.out" &&
    Run "$NYCGCS" "-b" "<" $1 ">" ../tests/${basename}.b.out

    generatedfiles="$generatedfiles ${basename}.e.out" &&
    Run "$NYCGCS" "-e" "<" $1 ">" ../tests/${basename}.e.out 

    # If the expected output is different from actual output, error

    notmatched=`diff -q ../tests/${basename}.expect.out ../tests/${basename}.e.out | wc -c`
    if [ "$notmatched" -gt "0" ]; then
	echo "Following file failed: ${basename}"
    fi
    
}

files="../tests/*.gs"

for file in $files
do
    Check $file 2>> $globallog
done

exit $globalerror
