{ open Parser }

rule token = parse
  [' ' '\t' '\n' '\r'] {token lexbuf}
| "/*" ['a'-'z' 'A'-'Z' '0'-'9' ' ' '-' '.']* "*/"	  { token lexbuf } (* Comments *)
| ';'             { SEMI }
| "beginfunction" { FUNCTION }
| "if"		  { IF }
| "compare"       { COMPARE }
| "return"        { RETURN }
| "else"	  { ELSE }
| "then"	  { THEN }
| "endfunction"	  { ENDFUNCTION }
| "var"	          { VARIABLE }
| "sendrequest"	  { SENDREQUEST }
| "fetchvalue"	  { FETCHVAL }
| "printtoscreen" { PRINTVALUE }
| '{'		  { LBRACE }
| '}'		  { RBRACE }
| '('		  { LPAREN }
| ')'		  { RPAREN }
| '='		  { ASSIGN }
| ','		  { COMMA }
| "repeat"	  { REPEAT }
| "until"	  { UNTIL }
| "for"		  { FOR }
| "in"		  { IN }
| "add"		  { ADD }
| ['a'-'z' 'A'-'Z' ]+ ['a'-'z' 'A'-'Z' '0'-'9']* as lxm { ID(lxm) }
| '"' ['0'-'9']+ '"' as lxm { ID(lxm) }
| '"' ['a'-'z' 'A'-'Z' '0'-'9' ' ' '-' '.' '&']* '"' as lxm { TEXTLINE(lxm) }
| eof 		  { EOF }
| _ as char { raise (Failure("illegal character " ^ Char.escaped char)) }
