type action = Bytecode | Execute

let _ =
  let action = if Array.length Sys.argv > 1 then
    List.assoc Sys.argv.(1) [ ("-b", Bytecode);
			      ("-e", Execute) ]
  else Execute (* action = Execute at this point*)
  in
  let lexbuf = Lexing.from_channel stdin in
  let program = Parser.program Scanner.token lexbuf in
  match action with
   Bytecode -> let listing =
      Bytecode.string_of_prog (Compile.translate program)
    in print_endline listing
  | Execute -> Execute.execute_prog (Compile.translate program) 
