%{ open Ast %}

%token SEMI FUNCTION IF COMPARE RETURN ELSE THEN ENDFUNCTION VARIABLE
%token SENDREQUEST FETCHVAL PRINTVALUE LBRACE RBRACE LPAREN RPAREN
%token ASSIGN EOF COMMA ADD
%token REPEAT UNTIL FOR IN
%token <string> ID
%token <string> TEXTLINE

%nonassoc NOELSE
%nonassoc ELSE
%right ASSIGN

%start program
%type <Ast.program> program

%%

program:
   /* nothing */ { [], [] }
 | program vdecl { ($2 :: fst $1), snd $1 }
 | program fdecl { fst $1, ($2 :: snd $1) }

fdecl:
   FUNCTION ID formals_opt LBRACE vdecl_list stmt_list RBRACE ENDFUNCTION
     { { fname = $2;
	 formals = $3;
	 locals = List.rev $5;
	 body = List.rev $6 } }

formals_opt:
    /* nothing */ { [] }
  | formal_list   { List.rev $1 }

formal_list:
    ID                   { [$1] }
  | formal_list ID { $2 :: $1 }

vdecl_list:
    /* nothing */    { [] }
  | vdecl_list vdecl { $2 :: $1 }

vdecl:
  VARIABLE ID SEMI { $2 }

stmt_list:
    /* nothing */  { [] }
  | stmt_list stmt { $2 :: $1 }

stmt:
    expr SEMI { Expr($1) }
  | RETURN expr SEMI { Return($2) }
  | LBRACE stmt_list RBRACE { Block(List.rev $2) }
  | IF expr THEN stmt %prec NOELSE { If($2, $4, Block([])) }
  | IF expr THEN stmt ELSE stmt    { If($2, $4, $6) }
  | REPEAT stmt UNTIL expr SEMI	   { Repeat($2,$4) }
  | FOR ID IN LPAREN actuals_list RPAREN stmt { Forin($2,$5,$7) }

textexpr :
    TEXTLINE { Text($1) }

expr:
    ID		{ Id($1) }
|   ID ASSIGN expr { Assign($1,$3) }
|   ID LPAREN actuals_opt RPAREN { Call($1,$3) }
|   COMPARE LPAREN expr expr RPAREN { CompareVal($3,$4) }
|   ADD LPAREN expr expr RPAREN { AddVal($3,$4) }
|   FETCHVAL LPAREN expr ID RPAREN { FetchVal($3,$4) }
|   FETCHVAL LPAREN expr TEXTLINE RPAREN { FetchVal($3,$4) }
|   PRINTVALUE LPAREN expr RPAREN { PrintVal(Print,$3) }
|   PRINTVALUE LPAREN textexpr RPAREN { PrintVal(Print,$3) }
|   SENDREQUEST LPAREN actuals_list RPAREN { SendWebRequest(SendRequest,$3) }

actuals_opt:
    /* nothing */ { [] }
  | actuals_list  { List.rev $1 }

actuals_list:
    expr                { [$1] }
  | textexpr		{ [$1] }
  | actuals_list expr { $2 :: $1 }
