open Ast
open Bytecode
open Lwt
open Cohttp
open Cohttp_lwt_unix

let execute_prog prog =
	let locals = Array.make 1024 "0" (* This is local array *)
	and globals = Array.make prog.num_globals "0"
	and temps = Array.make 100 "0" (* Temporary array *)
	and stack = Array.make 100 0 
	and currentln j l = if j < l then l else j
	and sentinel = "thisisanobject" in (*This would hold the program states and would be useful for jumping to functions and returning. *)
(* sp = Stack pointer,
   pc = index used to go through bytecode,
   tc = index used to go through temporary array,
   ln = offset into the local array. This signifies when a new block (which has its own locals) starts,
   lst = index of the last object that was added
   If the 4th element after the 'i' matches "thisisanobject", then assume that we are processing an object*)
  let rec exec sp pc tc ln lst= match prog.text.(pc) with
	LLocal i -> if locals.(ln+i+4) = sentinel then 
			( for k = 0 to 4 do  
			temps.(tc + k) <- locals.(ln+i + k) 
		    	done ; exec sp (pc+1) (tc+5) ln lst)
		    else ( temps.(tc) <- locals.(ln+i); exec sp (pc+1) (tc+1) ln lst)
  |	LGlobal i -> if globals.(i+4) = sentinel then
			( for k = 0 to 4 do
			temps.(tc + k) <- globals.(i + k) 
		    	done ; exec sp (pc+1) (tc+5) ln lst)
		    else ( temps.(tc) <- globals.(i);exec sp (pc+1) (tc+1) ln lst)
  |	Bin op -> 
	  temps.(0) <- (  match op with
		Add -> "\"" ^ string_of_int ((int_of_string(Str.global_replace (Str.regexp "\"") "" temps.(tc - 2))) + (int_of_string(Str.global_replace (Str.regexp "\"") "" temps.(tc - 1)))) ^ "\""
	  |	Compare -> string_of_int (compare (int_of_string(Str.global_replace (Str.regexp "\"") "" temps.(tc - 2))) (int_of_string(Str.global_replace (Str.regexp "\"") "" temps.(tc - 1))))
	  |	FetchValue -> "\"" ^ temps.(tc - 1) ^ "\"" (* The last value in temp array is required val *)
	); temps.(4) <- "0"; exec sp (pc+1) 1 ln lst (*The temps array has been reset with this call *)
  |	Jsr i -> stack.(sp) <- (pc + 1);stack.(sp+1) <- ln; (* Push the program counter on stack. When subroutine completes, execution should start from here. *)
		exec (sp+2) i tc ln lst
  |	Gnf i -> temps.(tc - 5) <- temps.(tc - 5 + i); (* The temps array contains the response object. Fetch the property at offset and store it at the place where the response object is stored thus reusing the temps array *)
		temps.(tc -1) <- "0"; exec sp (pc + 1) (tc-4) ln lst
  |	PLocal i -> print_endline (locals.(ln+i)); exec sp (pc+1) 0 ln lst
  |	PGlobal i -> print_endline (globals.(i)); exec sp (pc+1) 0 ln lst
  |	PTemp -> print_endline(temps.(tc-1)); exec sp (pc+1) 0 ln lst
  |	SLocal i -> (* Need to check if we are storing object *)
		if temps.(tc-1) = sentinel then
			( for k = 5 downto 1 do
			locals.(ln+i+5-k) <- temps.(tc-k)
			done; exec sp (pc+1) 0 ln (currentln i lst))
		else (locals.(ln+i) <- temps.(tc-1); exec sp (pc+1) 0 ln (currentln i lst))	
  |	SGlobal i -> (* Need to check if we are storing object *)
		if temps.(tc-1) = sentinel then
			( for k=5 downto 1 do
			globals.(i+5-k) <- temps.(tc-k)
			done; exec sp (pc+1) 0 ln lst)
		else ( globals.(i) <- temps.(tc-1); exec sp (pc+1) 0 ln lst)
  |	STemp s -> temps.(tc) <- s; exec sp (pc+1) (tc+1) ln lst
  |	Hlt     -> ()
  |	Ent i -> (* Push all temporary values to local stack and reset temporary. The temporary values were sent as arguments. *)
	if tc > 0 then
	( for k=(tc-1) downto 0 do
		(* lst -1 + i + tc - 1 - k *)
	  locals.(lst-1+i+tc-1-k) <- temps.(k) 
	  done; exec sp (pc+1) 0 lst (lst+tc)
	)
	else exec sp (pc+1) 0 lst lst
  |	Skip i -> if tc > 0 then
		  begin
			if temps.(tc-1) = "0" then
		  		exec sp (pc+1) tc ln lst
		 	else if temps.(tc-1) = "1" then
	  			exec sp (pc+1) tc ln lst
		 	else
				exec sp (pc+i+1) tc ln lst
		 end
		 else exec sp (pc+i+1) tc ln lst
  |	Rts i -> let new_pc=stack.(sp-2) and new_ln=stack.(sp-1) in
		 temps.(4) <- "0"; exec (sp-2) new_pc tc new_ln 0
  |	Loop  -> stack.(sp) <- (pc + 1);stack.(sp+1) <- ln;
		exec (sp+2) (pc+1) tc ln lst (* Similar to Jsr *)
  |	GoBackLoop -> let new_pc=stack.(sp-2) and new_ln=stack.(sp-1) in
			exec sp new_pc tc new_ln 0 (* Similar to Rts *)
  |	EndLoop -> exec (sp-2) (pc+1) tc ln lst (* Perform cleanup *)
  |	LSkip i -> stack.(sp) <- (pc + 1); stack.(sp+1) <- ln;
		exec (sp+2) (pc+i+1) tc ln lst (* Similar to Jsr *)
  |	EndForLoop -> let new_pc=stack.(sp-2) and new_ln=stack.(sp-1) in
			exec (sp-2) new_pc tc new_ln 0 (* Similar to Rts *)
  |	SendReq -> 

	let test =
	let body = 
  	Client.get (Uri.of_string ("http://data.cityofnewyork.us/resource/ebb7-mvp5.json?month=2014%20/%2001&borough="^(Str.global_replace (Str.regexp_string "\"") "" (temps.(tc-2)))^"&communitydistrict="^(Str.global_replace (Str.regexp_string "\"") "" (temps.(tc-1))))) >>= fun (resp, body) ->
  Cohttp_lwt_body.to_string body
	in Lwt_main.run body
	in let splitBody = Str.split (Str.regexp "[,]+") (Str.global_replace (Str.regexp "[^0-9,./]") "" test) in
	temps.(tc) <- string_of_int (truncate (float_of_string(List.nth splitBody 0)));
	temps.(tc+1) <- string_of_int (truncate(float_of_string(List.nth splitBody 1)));
	temps.(tc+2) <- (List.nth splitBody 2);
	temps.(tc+3) <- (List.nth splitBody 4);
	temps.(tc+4) <- sentinel;
	exec sp (pc+1) (tc+5) ln lst;

  in exec 0 0 0 0 0
	
