type op = Compare | FetchValue | Add
type sendop = SendRequest
type printop = Print

type expr = 
  Id of string
| Text of string
| PrintVal of printop * expr
| CompareVal of expr * expr
| FetchVal of expr * string
| AddVal of expr * expr
| Assign of string * expr
| SendWebRequest of sendop * expr list
| Call of string * expr list
| Noexpr

type stmt =
  Block of stmt list
| Expr of expr
| Return of expr
| If of expr * stmt * stmt
| Repeat of stmt * expr
| Forin of string * expr list * stmt 

type func_decl = {
	fname : string;
	formals : string list;
	locals : string list;
	body: stmt list;
}

type program = string list * func_decl list
