/* Dragon Curve */
include "../Standard/standard.geo"

main():
	class Math math
	class Config config
	class Polyline a, b
	int x

	/* Initialize origin and cutting/retract planes */
	config = Config([retract_height:5.0, cutting_height:-1.0, feed_rate:100.0])
	config.lcs.Identity()

	/* Create the first line for the dragon curve */
	a = Polyline([config:config, desc:"(Dragon Curve)"])
	a.AddPoint(Point([x:-10.0, y:0.0]), a.config.lcs)

	/* dragon curve iterations */
	for (x = 0; x < 12; x = x + 1):
		/* copy the previous geometries */
		b = a

		/* Create a new copy rotated 90 degrees around the end point */
		b.Reverse()
		b.Rotate(math.ToRad(-90.0))

		/* Append new copy ro the original polyline */
		a.Append(b)

	/* Output initilization NC code */
	GCodeInit(config)

	/* Output NC code for dragon curve */
	a.Print()	

