/* Olympic Rings */
include "../Standard/standard.geo"

main():
	class Circle a, b, c, d, e
	class Config config

	/* Initialize origin and cutting/retract planes */
	config = Config([retract_height:5.0, cutting_height:-1.0, feed_rate:100.0])
	config.lcs.Translate(10.0, 20.0)

	/* Top row of olympic circles */
	a = Circle([config:config, radius:9.0, desc:"(Circle 1)"])

	b = a
	b.desc = "(Circle 2)"
	b.Translate(20.0, 0.0)

	c = b
	c.desc = "(Circle 3)"
	c.Translate(20.0, 0.0)

	/* Bottom row of olympic circles */
	d = a
	d.desc = "(Circle 4)"
	d.Translate(10.0, -10.0)

	e = d
	e.desc = "(Circle 5)"
	e.Translate(20.0, 0.0)

	/* Output initilization NC code */
	GCodeInit(config)

	/* Output NC code for each circle */
	a.Print()	
	b.Print()	
	c.Print()
	d.Print()
	e.Print()

