GCodeInit(class Config config):
	print("G21")
	print("T1")
	print("G0 Z" + <string>(config.retract_height))
	print("G21")

class Math:
	Pi():
		return 3.1415926535897932384626
	
	ToRad(double degree):
		return ((degree / 180.0) * 3.1415926535897932384626)

	Tolerance():
		return .00000001

class Point:
	double x
	double y

	Magnitude():
		return sqrt((x * x) + (y * y))

	DotProduct(double x1, double y1):
		return (x * x1) + (y * y1)

	Translate(double u, double v):
		x = x + u
		y = y + v

	Rotate(double radians):
		double temp
		
		temp = (x * cos(radians)) - (y * sin(radians))
		y = (y * cos(radians)) + (x * sin(radians))
		x = temp

	ToIdentity(class LCS lcs):
		class Point end_pt
		double x_offset, y_offset

		x_offset = lcs.axes.u.DotProduct(1.0, 0.0) * x 
		x_offset = x_offset + (lcs.axes.v.DotProduct(1.0, 0.0) * y)

		y_offset = lcs.axes.u.DotProduct(0.0, 1.0) * x
		y_offset = y_offset + (lcs.axes.v.DotProduct(0.0, 1.0) * y)

		end_pt = lcs.origin
		end_pt.Translate(x_offset, y_offset)

		return end_pt

	Print():
		print(x)
		print(y)

class Axes:
	class Point u
	class Point v

	Print():
		u.Print()
		v.Print()

/* local coordinate system */
class LCS:
	class Point origin
	class Axes axes

	Identity():
		origin.x = 0.0
		origin.y = 0.0

		axes.u.x = 1.0
		axes.u.y = 0.0

		axes.v.x = 0.0
		axes.v.y = 1.0

	Translate(double u, double v):
		origin.x = origin.x + u
		origin.y = origin.y + v

	Rotate(double radians):
		axes.u.Rotate(radians)
		axes.v.Rotate(radians)

	Print():
		origin.Print()
		axes.Print()

/* Machining configuration options */
class Config:
	class LCS lcs
	double retract_height
	double cutting_height
	double feed_rate

