/* Polyline rotate test */
include "../Standard/standard.geo"

main():
	class LCS lcs
	class Math math
	class Config config
	class Polyline a, b
	list[class Polyline] polylines
	int x

	config = Config([retract_height:5.0, cutting_height:-1.0, feed_rate:100.0])
	config.lcs.Identity()

	a = Polyline([config:config, desc:"(Polyline 1)"])

	a.AddPoint(Point([x:10.0, y:10.0]), a.config.lcs)
	a.AddPoint(Point([x:-10.0, y:10.0]), a.config.lcs)
	a.AddPoint(Point([x:-10.0, y:-10.0]), a.config.lcs)
	a.AddPoint(Point([x:10.0, y:-10.0]), a.config.lcs)
	a.AddPoint(Point([x:10.0, y:10.0]), a.config.lcs)

	b = a
	for (x = 2; x <= 9; x = x + 1):
		b.desc = "(Polyline " + <string>(x) + ")"
		b.Rotate(math.ToRad(45.0))
		polylines.push(b)

	GCodeInit(config)

	a.Print()

	for (x = 0; x < polylines.count(); x = x + 1):
		polylines.at(x).Print()

