DoubleString(double a):
	class Math math
	
	if a < math.Tolerance():
		if a > -(math.Tolerance()):
			return "0."

	return <string>(a) 

class Line:
	class Point end
	string desc
	class Config config

	EndPoint():
		return end.ToIdentity(config.lcs)

	Translate(double u, double v):
		config.lcs.Translate(u, v)

	Rotate(double radians):
		config.lcs.Rotate(radians)

	Print():
		string start_string, end_string, feed_rate
		class Point start_pt, end_pt

		start_pt = config.lcs.origin 
		end_pt = EndPoint()

		if (desc):
			print(desc)

		start_string = "X" + DoubleString(start_pt.x) + " Y" + DoubleString(start_pt.y)
		end_string = "X" + DoubleString(end_pt.x) + " Y" + DoubleString(end_pt.y)
		feed_rate = " F" + DoubleString(config.feed_rate)

		print("G0 " + start_string)
		print("G1 Z" + DoubleString(config.cutting_height) + feed_rate)
		print("G1 " + end_string + feed_rate)
		print("G0 Z" + DoubleString(config.retract_height))


class Polyline:
	list [class Point] points
	string desc
	class Config config

	AddPoint(class Point pt, class LCS lcs):
		points.push(pt)

	EndPoint():
		class Point end_pt

		if points:
			end_pt = points.at((points.count() - 1))
			return end_pt.ToIdentity(config.lcs)
		else:
			return config.lcs.origin
		
	Reverse():
		list [class Point] old_points
		class Point old_start_pt, pt
		double x_change, y_change
		int x

		if points:
			old_start_pt = config.lcs.origin
			config.lcs.origin = points.pop()			

			x_change = old_start_pt.x - config.lcs.origin.x
			y_change = old_start_pt.y - config.lcs.origin.y

			old_points = points.reverse()
			points = []

			for (x = 0; x < old_points.count(); x = x + 1):
				pt = old_points.at(x)
				pt.Translate(x_change, y_change)
				points.push(pt)

			pt = old_start_pt
			pt.Translate(x_change, y_change)
			points.push(pt)

	Translate(double u, double v):
		config.lcs.Translate(u, v)

	Rotate(double radians):
		config.lcs.Rotate(radians)

	Append(class Polyline polyline):
		list[class Point] new_pts
		class Point pt
		int x

		new_pts = polyline.points
		
		for (x = 0; x < new_pts.count(); x = x + 1):
			pt = new_pts.at(x)
			pt = pt.ToIdentity(polyline.config.lcs)
			points.push(pt)

	Print():
		string start_string, end_string, feed_rate
		class Point start_pt, end_pt
		int x

		start_pt = config.lcs.origin 

		if (desc):
			print(desc)

		start_string = "X" + DoubleString(start_pt.x) + " Y" + DoubleString(start_pt.y)
		print("G0 " + start_string)

		if points:
			feed_rate = " F" + DoubleString(config.feed_rate)
			print("G1 Z" + DoubleString(config.cutting_height) + feed_rate)

		for (x = 0; x < points.count(); x = x + 1):
			end_pt = points.at(x)
			end_pt = end_pt.ToIdentity(config.lcs)

			end_string = "X" + DoubleString(end_pt.x) + " Y" + DoubleString(end_pt.y)
			print("G1 " + end_string + feed_rate)
		
		print("G0 Z" + DoubleString(config.retract_height))

class Circle:
	double radius
	string desc
	class Config config

	Translate(double u, double v):
		config.lcs.Translate(u, v)

	Print():
		string circle_start, feed_rate
		string circle_start_x, circle_start_y

		if (desc):
			print(desc)

		circle_start_x = DoubleString(config.lcs.origin.x + radius)
		circle_start_y = DoubleString(config.lcs.origin.y)
		circle_start = "X" + circle_start_x + " Y" + circle_start_y
		feed_rate = " F" + DoubleString(config.feed_rate)

		print("G0 " + circle_start)
		print("G1 Z" + DoubleString(config.cutting_height) + feed_rate)
		print("G2 " + circle_start + " I10 J0" + feed_rate)
		print("G0 Z" + DoubleString(config.retract_height))

