{ 
	open Utility
	open Parser 

	(* Used to output error for unknown syntax *)
	exception Syntax_error of string
	let syntax_error msg = raise (Syntax_error (msg ^ " on line: " ^ (string_of_int !current_parse_line)))
}


(* code used to parse a double *)
let digit = ['0'-'9']
let sign = ['+' '-']
let exponent = ('e'(sign?)digit+)
let fpn =                        (* Floating point number *)
(digit*)'.'(digit+)(exponent?)   (* optional integer, required decimal, optional exponent *)
| (digit+)'.'(digit*)(exponent?) (* required integer, optional decimal, optional exponent *)
| (digit+)exponent               (* required integer, no decimal, required exponent *)

let non_string_char = [^ '"' '\n' ]

rule token = parse
  [' ' '\t' '\r'] { token lexbuf } (* Whitespace *)
| "/*"     { comment lexbuf }           (* Comments *)
| '('      { LPAREN }
| ')'      { RPAREN }
| '{'      { LBRACE }
| '}'      { RBRACE }
| '['      { LSQBRACKET }
| ']'      { RSQBRACKET }
| ';'      { SEMI }
| ':'      { COLON }
| '@'      { AT }
| ','      { COMMA }
| '+'      { PLUS }
| '-'      { MINUS }
| '*'      { TIMES }
| '/'      { DIVIDE }
| '='      { ASSIGN }
| "=="     { EQ }
| "!="     { NEQ }
| '<'      { LT }
| "<="     { LEQ }
| ">"      { GT }
| ">="     { GEQ }
| "if"     { IF }
| "else"   { ELSE }
| "for"    { FOR }
| "while"  { WHILE }
| "return" { RETURN }
| "int"    { INT }
| "string" { STRING }
| "double" { DOUBLE }
| "bool"   { BOOL }
| "list"   { LIST }
| "class"  { CLASS }
| "true"   { TRUE }
| "false"  { FALSE }
| '.'      { ACCESS }
| "__BEGIN_OF_INCLUDE__" ([^ '\n']* as file_path) "!@<" { current_include_parse_file := file_path; incr current_parse_line; token lexbuf }
| "__START_MAIN_FILE__" ([^ '\n']* as file_path) "!@<" { main_parse_file := file_path; token lexbuf }
| "__END_OF_INCLUDE__" { current_include_parse_file := ""; current_parse_line := 3; token lexbuf }
| ['0'-'9']+ as lxm { INTLITERAL(int_of_string lxm) }
| '"' ([^ '"' '\n' ]* as lxm) '"' { STRINGLITERAL(lxm) }
(* | '"' (['a'-'z' 'A'-'Z' '0'-'9' '_']* as lxm) '"' { STRINGLITERAL(lxm) } *)
| fpn as lit { DOUBLELITERAL(float_of_string lit) }
| ['a'-'z' 'A'-'Z']['a'-'z' 'A'-'Z' '0'-'9' '_']* as lxm { ID(lxm) }
(* | ['A'-'Z']['a'-'z' 'A'-'Z' '0'-'9' '_']* as classname { CLASSTYPE(classname) } *)
| '\n' { incr current_parse_line; token lexbuf } 
| eof { EOF }
(* | _ as char { raise (Failure("illegal character " ^ Char.escaped char)) } *)
 | _ { syntax_error "couldn't identify the token" }

and comment = parse
  "*/" { token lexbuf }
| _    { comment lexbuf }
