module NameMap = Map.Make(struct
  type t = string
  let compare x y = Pervasives.compare x y
end)

type op = Add | Sub | Mult | Div | Equal | Neq | Less | Leq | Greater | Geq

type var =
    Int
  | String
  | Bool
  | List of var
  | Double
  | ClassType of string

type var_decl = {
    vtype : var;
    vname : string;
  }

type literal =
    IntLiteral of int
  | BoolLiteral of bool
  | StringLiteral of string
  | DoubleLiteral of float
  | ClassLiteral of literal NameMap.t
  | ListLiteral of literal list
  | KVPLiteral of string * literal (* key value pair *)
  | LhsLiteral of string * literal (* Left hand side value *)

type expr =
    Literal of literal
  | Id of string
  | Binop of expr * op * expr
  | Assign of expr * expr
  | Call of string * expr list
  | ClassCall of expr * string * expr list
  | Access of expr * string
  | Noexpr
  | Negate of expr
  | Cast of var * expr
  | ListItems of list_item list
and
 list_item = {
    lkey : string;
    lvalue : expr;
} 

type stmt =
    Block of stmt list
  | Expr of expr
  | Return of expr
  | If of expr * stmt * stmt
  | For of expr * expr * expr * stmt
  | While of expr * stmt

type func_decl = {
    fname : string;
    formals : var_decl list;
    locals : var_decl list;
    body : stmt list;
  }

type class_decl = {
    class_name : string;
    data_members : var_decl list;
    function_members : func_decl list;
  }

type program = var_decl list * func_decl list * class_decl list





