{ open Parser }

rule token = parse
| [' ' '\t' '\r' '\n'] { token lexbuf } (* Whitespace *)
| "/*"        { comment lexbuf } 
| ';'         { SEMI} 
| '('         { LPAREN }
| ')'         { RPAREN }
| '['         { LBRACK }
| ']'         { RBRACK } 
| '{'         { LBRACE }
| '}'         { RBRACE }
| ','      { COMMA }
| ':'      { COLON }
| '+'      { PLUS }
| '-'      { MINUS }
| '*'      { TIMES }
| '/'      { DIVIDE }
| '='      { ASSIGN }
| "in"     { IN }
| "=="     { EQ }
| "!="     { NEQ }
| '<'      { LT }
| "<="     { LEQ }
| ">"      { GT }
| ">="     { GEQ }
| "if"     { IF }
| "else"   { ELSE }
| "iterate" { FOR }
| "while"  { WHILE }
| "return" { RETURN }
| "Int"    { INT }
| "Dict"   { DICT }
| "func"   { FUNC }
| "Array"  { ARRAY } 
| "String" { STRING } 
| ['0'-'9']+ as lxm { INTLITERAL(int_of_string lxm) }
| ['a'-'z' 'A'-'Z']['a'-'z' 'A'-'Z' '0'-'9' '_']* as lxm { ID(lxm) }
| '"' [^'"']* '"' as l { STRINGLITERAL(l) }
| eof { EOF }
| _ as char { raise (Failure("illegal character " ^ Char.escaped char)) }

and comment = parse
  "*/" { token lexbuf }
| _    { comment lexbuf }
