// On an input of the integers 1 to 10, this program will output 1-8. This is
// because each "buffer" kernel does two reads. Since 10%2 == 2, these reads
// will hang forever. Therefore we just terminate the program.

kernel src(in data, out even, out odd)
{
    while(true)
    {
        token = read(data);

        is_even = token % 2 == 0;

        if (is_even)
        {
          write(even, token);
        }
        else
        {
          write(odd, token);
        }
    }
}

kernel buffer(in data_in, out data_out)
{
    while (true)
    {
        first = read(data_in);
        second = read(data_in);

        write(data_out, first);
        write(data_out, second);
    }
}

kernel sink(in even_data, in odd_data, out output)
{
    while (true)
    {
        write(output, read(odd_data));
        write(output, read(even_data));
    }
}

channel src_to_even, src_to_odd, even_to_sink, odd_to_sink;

src(stdin, src_to_even, src_to_odd);
buffer(src_to_even, even_to_sink);
buffer(src_to_odd, odd_to_sink);
sink(even_to_sink, odd_to_sink, stdout);
