channel loop_channel;

kernel fibonacci(n, seed_1, seed_2, in source, out feedback, out output)
{
    // seed the input with the values
    write(feedback, seed_1);
    write(feedback, seed_2);

    // write the first two values as output
    write(output, seed_1);
    write(output, seed_2);

    for (counter = 2; counter <= n; counter = counter + 1)
    {
        // read the two values
        f_1 = read(source);
        f_2 = read(source);

        // calculate the next number
        fib = f_1 + f_2;

        // write the number to the output
        write(output, fib);

        // write the next two numbers back in to the feedback loop
        write(feedback, f_2);
        write(feedback, fib);
    }

    print("All done!");
}

// print the first 10 fibonacci numbers (starting with 0 and 1) to stdout
fibonacci(10, 0, 1, loop_channel, loop_channel, stdout);
