{
open Bytecode

type token = EOF | Value of value
}

let number = ['0'-'9']
let integer = number+
let exponent =  'e' ['+' '-']? integer
let fraction = '.' integer
let whitespace = [' ' '\n' '\t' '\r']

rule token = parse
    eof { EOF }
  | (integer? fraction exponent?) | (integer '.'? exponent) | (integer '.')
        as num              { Value(Float(float_of_string num)) }
  | integer as num          { Value(Int(int_of_string num)) }
  | "true"                  { Value(Bool(true)) }
  | "false"                 { Value(Bool(false)) }
  | [^ ' ' '\n' '\t' '\r']+ as str  { Value(String(str)) }
  | whitespace              { token lexbuf }
