{ open Parser }

rule token = parse
    | [' ' '\t' '\r' '\n']  { token lexbuf }
    | "/*"     { comment lexbuf }
    | '|'      { BAR}
    | '('      { LPAREN }
    | ')'      { RPAREN }
    | '{'      { LBRACE }
    | '}'      { RBRACE }
    | ';'      { SEMI }
    | ','      { COMMA }
    | '+'      { PLUS }
    | '-'      { MINUS }
    | '*'      { TIMES }
    | '/'      { DIVIDE }
    | '='      { ASSIGN }
    | "=="     { EQ }
    | "!="     { NEQ }
    | '<'      { LT }
    | "<="     { LEQ }
    | ">"      { GT }
    | ">="     { GEQ }
    | "if"     { IF }
    | "else"   { ELSE }
    | "for"    { FOR }
    | "while"  { WHILE }
    | "return" { RETURN }
    | "["      { LBRACKET }
    | "]"      { RBRACKET }
    | "int" as dt    { DATA_TYPE(dt) }
    | "matrix" as dt { DATA_TYPE(dt) }
    | ['0'-'9']+ as lxm { LITERAL(int_of_string lxm) }
    | ['a'-'z']['a'-'z' 'A'-'Z' '0'-'9' '_']* as lxm    { ID(lxm) }
    | ['\"']['a'-'z' 'A'-'Z' '0'-'9' '_' '.' ':' '-' ' ' '/']*['\"'] as str  { STRING(str) }
    | eof { EOF }
    | _ as char { raise (Failure("illegal character " ^ Char.escaped char)) }

and comment = parse
      "*/"  { token lexbuf }
    | _     { comment lexbuf }
