#include <stdio.h>
#define input_size 3
/* List of all states as defined in STATES*/

typedef enum STATES { 
locked,
unlocked
} STATES;

/* List of all possible signals into state machine*/

typedef enum SIGNALS {
coin,
push
} SIGNALS;

/* Actions at each state */
void coin_action ()
{
	printf("Coin Inserted \n");
}

void push_action ()
{
	printf("Latch Pushed \n");
}

void lock_action ()
{
	printf("Door Locked \n");
}

int main()
{
	/*Default State of Machine*/
	STATES state = locked;	
	int event = 0;
	/*List of Inputs*/
	SIGNALS input_signals[input_size] = {push, coin, push};

	
	for(; event < input_size; event++)
	{
			/*SIGNALS tmp = input_signals[event];*/
			
			switch(input_signals[event])
			{
				case push:
				{
					switch(state)
					{
						case locked:
						{
							lock_action();
							state = locked;
							break;
						}
						case unlocked:
						{
							push_action();
							state = locked;
							break;
						}
					}
				break;
				}
				case coin:
				{
					switch(state)
					{
						case locked:
						{
							coin_action();
							state = unlocked;
							break;
						}
						case unlocked:
						{
							coin_action();
							state = unlocked;
							break;
						}
					}
					break;
				}
			}
		}
		return 0;
}
