{ open Parser }

rule token = parse
  [' ' '\t' '\r' '\n'] { token lexbuf } (* Whitespace *)
| "//"     { comment lexbuf }           (* Comments *)
| '('      { LPAREN }
| ')'      { RPAREN }
| '{'      { LBRACE }
| '}'      { RBRACE }
| ';'      { SEMI }
| ‘:’      { COLON }
| ','      { COMMA }
| '='      { ASSIGN }
| "=>"     { SETTO }
| "if"     { IF }
| "CTRL_IN"    { SIGNAL_IN }
| "DEFAULT_STATE" { DEFAULT_STATE  }
| "LIST_ACTIONS" { LIST_ACTIONS }
| "true"   { BOOLEAN_LIT(true) }
| "false"  { BOOLEAN_LIT(false) }
| ['0'-'9']+ as lxm { LITERAL(int_of_string lxm) }
| ['a'-'z' 'A'-'Z']['a'-'z' 'A'-'Z' '0'-'9' '_']* as lxm { ID(lxm) }
| eof { EOF }
| _ as char { raise (Failure("illegal character " ^ Char.escaped char)) }

and comment = parse
  "\n" { token lexbuf }
| eof  { EOF }
| _    { singlelinecom lexbuf}