open Ast

(* Symbol table: Information about all the names in scope *)
type env = {
    function_index : int StringMap.t; (* Index for each function *)
    global_index   : int StringMap.t; (* "Address" for global variables *)
    local_index    : int StringMap.t; (* FP offset for args, locals *)
  }


(*type for storing variables *)
type varSymbolTableEntry = {
  data_type : sealType;
}

(*the symbol table that contains global variables, as well as links to
lesser scope variable symbol tables *)
type symbolTable = {
  parent : symbolTable option;
  sealVarSymbolTable : sealType StringMap.t;
}

(*type for storing functions *)
type funcSymbolTableEntry = {
  ftype : sealType;
  fparameters : sealType StringMap.t;
  flocals :  sealType StringMap.t;
}

(*type for storing SEAL Threads and any local variables defined within the Thread *)
type threadSymbolTableEntry = {
  tlocals : sealType StringMap.t;
}

(*type for storing SEAL Interrupt handlers and any local variables defined within the handler*)
type interruptSymbolTableEntry = {
  ilocals : sealType StringMap.t;
}

(*type for storing SEAL types defined by the user*)
type typeTableEntry = {
  properties : sealType StringMap.t;
  functions : funcSymbolTableEntry StringMap.t;
}

(*the entire environment, containing the symbol table, the function table, 
  the thread table, the interrupt table, and the SEAL types table *)
type environment = {
  scope : symbolTable;
  sealFuncSymbolTable : funcSymbolTableEntry StringMap.t;
  sealThreadSymbolTable : threadSymbolTableEntry StringMap.t;
  sealInterruptSymbolTable : interruptSymbolTableEntry StringMap.t;
  sealTypeSymbolTable : typeTableEntry StringMap.t; (*TSG HMMMM *)
}
