import java.text.MessageFormat;

public class TestRTL {
    public static void main(String[] args) {
        TestRTL prog = new TestRTL();

        System.out.println("Starting tests");
        prog.Test_print();
        prog.Test_format();
        prog.Test_concat();
        prog.Test_substr();
        prog.Test_int_to();
        prog.Test_char_to();
        prog.Test_string_to();
        prog.Test_float_to();
        System.out.println("Finished tests");
    }

    private void Test_print() {
        //System.out.println("Testing rtl.print()");
        rtl.print("This is a test message");
    }

    private void Test_format() {
        System.out.println("Testing rtl.str_format()");

        String[] params = {"1", "9.9", "BLAH"};
        System.out.println(rtl.str_format("int: {0}, float: {1}, string: {2}", params));
    }

    private void Test_concat() {
        System.out.println("Testing rtl.str_concat()");

        String s1 = "Name";
        String s2 = "space";

        String full = rtl.str_concat(s1, s2);
        System.out.println(full);
    }

    private void Test_substr() {
        System.out.println("Testing rtl.str_substr()");

        String full = "Shades of Summer";
        String summer = rtl.str_substr(full, 10, 6); 
        System.out.println(MessageFormat.format("Summer = {0}", summer));
    }
        
    private void Test_int_to() {
        System.out.println("Testing int_to");

        String str0 = rtl.int_to_string( 0 );
        String str1 = rtl.int_to_string( 1234 );
        float f0 = rtl.int_to_float( 0 );
        float f1 = rtl.int_to_float( 1234 );
        char ch0 = rtl.int_to_char( 32 );
        char ch1 = rtl.int_to_char( 45 );

        assert str0.equals( "0" );
        assert str1.equals( "1234" );
        assert f0 == 0.0f;
        assert f1 == 1234.0f;
        assert ch0 == ' ';
        assert ch1 == '-';
    }

    private void Test_char_to() {
        System.out.println("Testing char_to");

        String str0 = rtl.char_to_string( ' ' );
        String str1 = rtl.char_to_string( 'R' );
        int i0 = rtl.char_to_int( ' ' );
        int i1 = rtl.char_to_int( 'E' );

        assert str0.equals( " " );
        assert str1.equals( "R" );
        assert i0 == 32;
        assert i1 == 69;
    }

    private void Test_string_to() {
        System.out.println("Testing string_to");

        int i0 = rtl.string_to_int( "0" );
        int i1 = rtl.string_to_int( "12345" );
        float f0 = rtl.string_to_float( "0.0" );
        float f1 = rtl.string_to_float( "1234.8976" );
        char ch0 = rtl.string_to_char( " " );
        char ch1 = rtl.string_to_char( "1" );

        assert i0 == 0;
        assert i1 == 12345;
        assert f0 == 0.0f;
        assert Math.abs( f1 - 1234.8976f ) < 0.0001f;
        assert ch0 == ' ';
        assert ch1 == (char)49;
    }

    private void Test_float_to() {
        System.out.println("Testing float_to");

        String str0 = rtl.float_to_string( 0.0f );
        String str1 = rtl.float_to_string( 99.87652f );
        int i0 = rtl.float_to_int( 0.0f );
        int i1 = rtl.float_to_int( 1234.3211f );

        assert str0.equals( "0.0" );
        assert str1.equals( "99.87652" );
        assert i0 == 0;
        assert i1 == 1234;
    }
}
