import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;

public class RtlOutFile {
    private boolean         d_headerWritten = false;
    private BufferedWriter  d_writer;
    private String          d_sep;

    public RtlOutFile(String filename, String sep) throws RtlException {
        try {
            d_sep = sep;
            d_writer = new BufferedWriter(new FileWriter(new File(filename)));
        } catch ( Exception e ) {
            throw new RtlException(e.getMessage());
        }
    }

    //  Write a line to the file, each element in the map seperated by d_sep
    //  string.
    //
    //  If a header has not yet been written, write one out first
    public void write(String[] header, Map<String, String> rec) {
        try {
            String line = join(header, d_sep);
            StringBuilder sb = new StringBuilder();

            for (int i = 0; i < header.length; ++i) {
                String data = "";
                if ( rec.containsKey(header[i]) ) {
                    data = rec.get(header[i]);
                }

                sb.append(data);
                if ( i + 1 < header.length ) {
                    sb.append(d_sep);
                }
            }

            if ( ! d_headerWritten ) {
                StringBuilder hd = new StringBuilder();

                for (int i = 0; i < header.length; ++i ) {
                    hd.append(header[i]);
                    
                    if ( i + 1 < header.length ) {
                        hd.append(d_sep);
                    }
                }

                d_writer.write(hd.toString() + "\n");
                d_headerWritten = true;
            }

            d_writer.write(sb.toString() + "\n");
            d_writer.flush();
        } catch ( Exception e ) {
            System.out.println(e.getMessage());
        }
    }

    private String join(String[] strs, String sep) {
        StringBuilder sb = new StringBuilder();

        for (int i = 0; i < strs.length; ++i) {
            sb.append(strs[i]);
            
            if ( i + 1 < strs.length ) {
                sb.append(sep);
            }
        }

        return sb.toString();
    }
}
