import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.HashMap;

public class RtlInFile {
    private BufferedReader  d_br;
    private String[]        d_header;
    private String          d_splitBy;
    private boolean         d_headerRead = false;
    
    public RtlInFile(String filename, String splitBy) throws RtlException {
        try {
            d_br = new BufferedReader(new FileReader(filename));    
            d_splitBy = splitBy;
        } catch ( Exception e ) {
            throw new RtlException(e.getMessage());
        }
    }

    public String[] getHeader() {
        return d_header;
    }

    //  Returns null on EOF
    public Map<String,String> read() {
        try {
            if ( ! d_headerRead ) {
                String line = d_br.readLine();
                if ( line == null ) {
                    return null;
                }

                d_header = line.split(d_splitBy);
                d_headerRead = true;
            }

            String line = d_br.readLine();
            if ( line == null ) {
                return null;
            }

            String[] row = line.split(d_splitBy);

            Map<String,String> rec = new HashMap<String, String>();
            int count = Math.min(d_header.length, row.length);

            for ( int i = 0; i < count; ++i ) {
                rec.put(d_header[i], row[i]);
            }

            return rec;
        } catch ( Exception e ) {
            System.out.println(e.getMessage());
            return null;
        }
    }
}


