import java.util.Map;

public class Rtl {
    public static RtlInFile create_in(String path, String sep) {
        try { 
            return new RtlInFile(path, sep);
        } catch ( RtlException e ) {
            System.out.println(e.getMessage());
        }

        return null;
    }
    
    public static RtlOutFile create_out(String path, String sep) {
        try { 
            return new RtlOutFile(path, sep);
        } catch ( RtlException e ) {
            System.out.println(e.getMessage());
        }

        return null;
    }

    public static String get_map_value(Map<String, String> map, String key) {
        if ( map.containsKey(key) ) {
            return map.get(key);
        } else {
            System.out.println("record does not contain a column named '" + key + "'");
            return "";
        }
    }

    public static void set_map_value(Map<String, String> map, String key, String value) {
        if ( map.containsKey(key) ) {
            map.put(key, value);
        } else {
            System.out.println("record does not contain a column named '" + key + "'");
        }
    }

    // String functions
    public static String substr(String s, int pos, int len) {
        try {
            return s.substring(pos, pos + len);
        } catch (Exception e) {
            return "";
        }
    }

    public static boolean equals(String s1, String s2) {
        try {
            return s1.equals( s2 );
        } catch (Exception e) {
            return false;
        }
    }

    public static String concat(String s1, String s2) {
        try {
            return s1 + s2;
        } catch (Exception e) {
            return "";
        }
    }

    public static String str_format(String pattern, String[] args) {
        try {
            java.text.MessageFormat mf = new java.text.MessageFormat(pattern);
            return mf.format(args, new StringBuffer(), null).toString();
        } catch (Exception e) {
            return "";
        }
    }

    //  Print
    public static void print(String s) {
        try {
            System.out.println(s);
        } catch (Exception e) {}
    }

    //  int_to_string
    //  int_to_float
    //  int_to_char
    public static String int_to_string(int value) {
        try { 
            return String.valueOf(value);
        } catch (Exception e) {
            return "";
        }
    }
    public static float int_to_float(int value) {
        try { 
            return (float)value;
        } catch (Exception e) {
            return 0.0f;
        }
    }
    public static char int_to_char(int value) {
        try { 
            return (char)value;
        } catch (Exception e) {
            return ' ';
        }
    }

    //  char_to_string
    //  char_to_int
    public static String char_to_string(char value) {
        try { 
            return String.valueOf(value);
        } catch (Exception e) {
            return "";
        }
    }
    public static int char_to_int(char value) {
        try { 
            return (int)value; 
        } catch (Exception e) {
            return 0;
        }
    }

    //  string_to_int 
    //  string_to_float 
    //  string_to_char 
    public static int string_to_int(String value) {
        try { 
            return Integer.parseInt(value);
        } catch (Exception e) {
            return 0;
        }
    }
    public static float string_to_float(String value) {
        try { 
            return Float.parseFloat(value);
        } catch (Exception e) {
            return 0.0f;
        }
    }
    public static char string_to_char(String value) {
        try { 
            return value.charAt( 0 );
        } catch (Exception e) {
            return ' ';
        }
    }


    //  float_to_string
    //  float_to_int
    public static String float_to_string(float value) {
        try { 
            return String.valueOf(value);
        } catch (Exception e) {
            return "";
        }
    }
    public static int float_to_int(float value) {
        try { 
            return (int)value;
        } catch (Exception e) {
            return 0;
        }
    }
}

