import java.util.Map;

public class ProcessExample {
    public static void main(String[] args) {
        RtlInFile inFile = Rtl.create_in("hello.csv", ",");
        RtlOutFile outFile = Rtl.create_out("example.csv", "|");

        __process_0( inFile, outFile );
    }
    
    public static boolean __filter_0( Map<String, String> rec ) {
          Rtl.set_map_value(rec, "col1", "BAD");
          return Rtl.get_map_value(rec, "col2").equals( "World" );
    }
    
    public static void __process_0( RtlInFile in, RtlOutFile out ) { 
        try {
            if ( in == null || out == null ) {
                return;
            }

            for(;;) {
                Map<String, String> rec = in.read();
                if ( rec == null ) {
                    break;
                }

                if ( ! __filter_0( rec ) ) {
                    continue;
                }

                out.write(in.getHeader(), rec);
            }

        } catch ( Exception e ) {
            System.out.println(e.getMessage());
        }
    }
}
