/****************************************************************************
 *
 * File: parser.mly
 *
 * Purpose: language yacc definition 
 *
 */

%{ open Ast %}

%token SEMI COLON LPAREN RPAREN LBRACK RBRACK MBEGIN MEND LBRACE RBRACE COMMA 
%token PLUS MINUS TIMES DIVIDE ASSIGN EQ NEQ LT LEQ GT GEQ LAND LOR 
%token FILE OUTPUT SEP PRINT BREAK CHECK ELSE FILE FILTER FOR FUNCTION IF LOG PROCESS RETURN TO WHILE 
%token CHAR FLOAT INT STRING BOOL

%token <string> LIT_FLOAT
%token <string> LIT_INT
%token <string> LIT_STR
%token <string> LIT_CHAR
%token <string> LIT_BOOL
%token <string> ID
%token EOF

%nonassoc NOELSE
%nonassoc ELSE  

%right ASSIGN 
%left LAND LOR
%left EQ NEQ
%left LT GT LEQ GEQ
%left PLUS MINUS
%left TIMES DIVIDE

%start program
%type <Ast.program> program

%%

program:
    /* nothing */                 { [] }
  | program stmt                  { $2 :: $1 }

process_list:
    /* empty */                   { [] }
  | process_list process_stmt     { $2 :: $1 }

process_stmt:
    CHECK check_stmt              { $2 }

check_stmt:
  | ID                            { Check_Function($1) }

formal_list:
    /* nothing */                 { [] }
  | formal_item                   { [$1] }
  | formal_list COMMA formal_item { $3 :: $1 }

formal_item:
  | BOOL ID                       { Variable(Bool, $2, Noexpr) }
  | CHAR ID                       { Variable(Char, $2, Noexpr) }
  | FLOAT ID                      { Variable(Float, $2, Noexpr) }
  | INT ID                        { Variable(Int, $2, Noexpr) }
  | STRING ID                     { Variable(String, $2, Noexpr) }

vdecl:
  | BOOL ID SEMI                  { Variable(Bool, $2, Noexpr) }
  | BOOL ID ASSIGN expr SEMI      { Variable(Bool, $2, $4) }
  | CHAR ID SEMI                  { Variable(Char, $2, Noexpr) }
  | CHAR ID ASSIGN expr SEMI      { Variable(Char, $2, $4) }
  | FLOAT ID SEMI                 { Variable(Float, $2, Noexpr) }
  | FLOAT ID ASSIGN expr  SEMI    { Variable(Float, $2, $4) }
  | INT ID SEMI                   { Variable(Int, $2, Noexpr) }
  | INT ID ASSIGN expr SEMI       { Variable(Int, $2, $4) }
  | STRING ID SEMI                { Variable(String, $2, Noexpr) }
  | STRING ID ASSIGN expr SEMI    { Variable(String, $2, $4) }

variable_type:
  | BOOL                          { Char } 
  | CHAR                          { Char } 
  | FLOAT                         { Float }
  | INT                           { Int }
  | STRING                        { String }

stmt_list:  
    /* nothing */                 { [] }
  | stmt_list stmt                { $2 :: $1 }

file_opts:
    /* nothing */                 { [] }
  | fopt_list                     { List.rev $1 }

fopt_list:
    fopt                          { [$1] }
  | fopt_list fopt                { $2 :: $1 }

fopt:
    OUTPUT                        { Output }
  | SEP ASSIGN LIT_STR            { Sep($3) }

stmt:
    expr SEMI                     { Expr($1) }
  | BREAK SEMI                    { Break }
  | RETURN expr SEMI              { Return($2) }
  | LBRACE stmt_list RBRACE       { Block(List.rev $2) }
  | IF LPAREN expr RPAREN stmt %prec NOELSE 
                                  { If($3, $5, Block([])) }
  | IF LPAREN expr RPAREN stmt ELSE stmt    
                                  { If($3, $5, $7) }
  | FOR LPAREN expr_opt SEMI expr_opt SEMI expr_opt RPAREN stmt
                                  { For($3, $5, $7, $9) }
  | WHILE LPAREN expr RPAREN stmt { While($3, $5) }

  | FUNCTION ID LPAREN formal_list RPAREN variable_type LBRACE stmt_list RBRACE
                                  { Function($2, List.rev $4, $6, Block(List.rev $8)) }
  | FILTER ID LBRACE stmt_list RBRACE      
                                  { FilterFunc($2, Block(List.rev $4)) }
  | PROCESS ID process_list TO ID SEMI
                                  { Process($2, List.rev $3, $5) }    
  | vdecl                         { Declare($1) }
  | LBRACE error RBRACE           { Expr(Noexpr) } 
  | FILE ID ASSIGN LIT_STR file_opts SEMI 
                                  { File($2, $4, $5) } 
  | PRINT expr SEMI               { Print($2) }

/*
str_format:
    expr                          { [$1] }
  | str_format COMMA expr         { $3 :: $1 }
*/

expr_opt:
    /* nothing */                 { Noexpr }
  | expr                          { $1 }

expr:
    LIT_INT                             { Literal_Int($1) }
  | LIT_FLOAT                           { Literal_Float($1) }
  | LIT_STR                             { Literal_String($1) }
  | LIT_CHAR                            { Literal_Char($1) }
  | LIT_BOOL                            { Literal_Bool($1) }
  | ID                                  { Id($1) }
  | expr PLUS   expr                    { Binop($1, Add,   $3) }
  | expr MINUS  expr                    { Binop($1, Sub,   $3) }
  | expr TIMES  expr                    { Binop($1, Mult,  $3) }
  | expr DIVIDE expr                    { Binop($1, Div,   $3) }
  | expr EQ     expr                    { Binop($1, Equal, $3) }
  | expr NEQ    expr                    { Binop($1, Neq,   $3) }
  | expr LT     expr                    { Binop($1, Less,  $3) }
  | expr LEQ    expr                    { Binop($1, Leq,   $3) }
  | expr GT     expr                    { Binop($1, Greater, $3) }
  | expr GEQ    expr                    { Binop($1, Geq,   $3) }
  | expr LAND   expr                    { Binop($1, LAnd,  $3) }
  | expr LOR    expr                    { Binop($1, LOr,   $3) }
  | expr ASSIGN expr                    { Assign($1, $3) }
  | ID LPAREN actuals_opt RPAREN        { Call($1, $3) }
  | LPAREN expr RPAREN                  { $2 }
  | ID LBRACK expr RBRACK               { MapAccess($1, $3) }

actuals_opt:
    /* nothing */                       { [] }
  | expr_list                           { List.rev $1 }

expr_list:
    expr                                { [$1] }
  | expr_list COMMA expr                { $3 :: $1 }

%%

let parse_error s = 
  print_endline ("error: {" ^ s ^ "} TODO")
